/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.dialect.ogr;

import com.northpool.exception.NotSupport;
import com.northpool.resources.Constants;
import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.resources.datatable.operate.FieldDefaultValueBean;
import com.northpool.resources.datatable.operate.TableSchemaBean;
import com.northpool.resources.dialect.ICreateTableFieldRefDialect;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.IResourcesDataInput;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.dialect.function.Function;
import com.northpool.resources.dialect.function.sql.SQLSpatialRelateFunction;
import com.northpool.resources.dialect.function.sql.SpatialFilterExpression;
import com.northpool.resources.dialect.ogr.OgrResourcesDataInput;
import com.northpool.resources.dialect.ogr.OgrResourcesDataOutput;
import com.northpool.resources.dialect.sql.AbstractSQLDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.spatial.Geom;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.type.Type;
import com.northpool.type.TypeBytes;
import com.northpool.type.TypeOgrGeometry;
import com.northpool.type.Types;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.gdal.ogr.Feature;
import org.locationtech.jts.geom.Geometry;

public class OgrDialect
extends AbstractSQLDialect
implements ISQLDialect {
    public static final IDialect INSTANCE = new OgrDialect();
    public static final String KEY_WORD_SERIAL = "esriFieldTypeOID";
    public static final String KEY__WORD_GEOMETRY = "esriFieldTypeGeometry";

    public String getSelfDesc() {
        return "fgdb\u65b9\u8a00";
    }

    public Constants.DATA_SOURCE_TYPE getDataSourceType() {
        return Constants.DATA_SOURCE_TYPE.fgdb;
    }

    public boolean isColumnSerial(ColumnBean columnBean, String columnTypeName) {
        return KEY_WORD_SERIAL.equalsIgnoreCase(columnTypeName);
    }

    public <TABLE_BUILD, FIELD> ICreateTableFieldRefDialect<TABLE_BUILD, FIELD> getCreateTableFieldRefDialect() {
        throw new UnsupportedOperationException("\u53ea\u8bfb\u6a21\u5f0f\u4e0d\u652f\u6301\u521b\u5efa\u8868\u5b57\u6bb5");
    }

    protected void registerTypes() {
        this.registerType((Type)Types.INTEGER, new String[]{"serial", "int", "int2", "int4", "integer"});
        this.registerClassType((Type)Types.INTEGER, new Class[]{Integer.class, Short.class});
        this.registerType(TypeOgrGeometry.INSTANCE, new String[]{"geometry"});
        this.registerClassType(TypeOgrGeometry.INSTANCE, new Class[]{Geometry.class, GeoBuffer.class, Geom.class});
        this.registerType((Type)Types.STRING, new String[]{"String"});
        this.registerClassType((Type)Types.STRING, new Class[]{String.class});
        this.registerType((Type)Types.DOUBLE, new String[]{"real", "float4", "float8", "double"});
        this.registerClassType((Type)Types.DOUBLE, new Class[]{Double.class, Float.class});
        this.registerType((Type)Types.BIGDECIMAL, new String[]{"numeric", "number"});
        this.registerClassType((Type)Types.BIGDECIMAL, new Class[]{BigDecimal.class, BigInteger.class});
        this.registerType((Type)Types.TIME_STAMP, new String[]{"timestamp", "dateTime", "Date"});
        this.registerClassType((Type)Types.TIME_STAMP, new Class[]{Date.class});
        this.registerType((Type)Types.BOOLEAN, new String[]{"boolean", "bool"});
        this.registerClassType((Type)Types.BOOLEAN, new Class[]{Boolean.class});
        this.registerType((Type)Types.LONG, new String[]{"long", "int8"});
        this.registerClassType((Type)Types.LONG, new Class[]{Long.class});
        this.registerType((Type)TypeBytes.INSTANCE, new String[]{"Binary", "byte[]"});
        this.registerClassType((Type)TypeBytes.INSTANCE, new Class[]{byte[].class});
    }

    protected void registerFunctions() {
        Type[] typeIn = new Type[]{TypeOgrGeometry.INSTANCE, TypeOgrGeometry.INSTANCE};
        this.registerFunction("intersects", (Function)new SQLSpatialRelateFunction("st_intersects", (Type)Types.BOOLEAN, typeIn));
        this.registerFunction("mbr_intersects", (Function)new SpatialFilterExpression((Type)Types.BOOLEAN, typeIn));
    }

    public IResourcesDataInput<Object, String> getResourcesDataDataInput() {
        return OgrResourcesDataInput.INSATNCE;
    }

    public IResourcesDataOutput<Feature, Integer> getResourcesDataOutput() {
        return OgrResourcesDataOutput.INSTANCE;
    }

    public String getLimitString(String sql, boolean hasOffset, List<Object> parameterList, List<Type> inputTypes, int firstResult, int maxResults) {
        throw new NotSupport();
    }

    public String getJDBCDriver() {
        throw new NotSupport();
    }

    public String createConnectUrl(String url) {
        return url;
    }

    public Boolean markForTableNameAndColumnName() {
        return true;
    }

    public void setFetchSize(Connection connection, PreparedStatement preparedStatement, Integer fetchSize) throws SQLException {
        throw new NotSupport();
    }

    public String createInsertSQL(String schema, String tableName, String[] fields) {
        throw new NotSupport();
    }

    public String createDeleteSQL(String schema, String tableName, String where) {
        throw new NotSupport();
    }

    public String createUpdateSQL(String schema, String tableName, String[] fields, String where) {
        throw new NotSupport();
    }

    public String getDefaultSchema() {
        throw new NotSupport();
    }

    public Boolean isFieldSerial(String columnTypeName) {
        if (KEY_WORD_SERIAL.equalsIgnoreCase(columnTypeName)) {
            return true;
        }
        return false;
    }

    public FieldDefaultValueBean.VALUE_TYPE getColumnDefaultValueType(String columnTypeName, String defaultValue) {
        throw new NotSupport();
    }

    public String[] getCreateTableSQLS(TableSchemaBean tableSchemaBean) {
        throw new NotSupport();
    }

    public String createSequenceName(String schema, String tableName, String fieldName) {
        throw new NotSupport();
    }

    public String hasSequenceSql(String sequenceName) {
        throw new NotSupport();
    }

    public String getCreateSequenceSQL(String sequenceName) {
        throw new NotSupport();
    }

    public String processTableNameAndSchema(String tableName) {
        return tableName;
    }

    protected boolean defaultValueIsSequence(String columnTypeName, String defaultValue) {
        return false;
    }

    protected boolean defaultValueIsFuntion(String columnTypeName, String defaultValue) {
        return false;
    }

    protected boolean defaultValueIsNowDate(String columnTypeName, String defaultValue) {
        return false;
    }
}

