/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datasource.ogr;

import com.northpool.resources.Constants;
import com.northpool.resources.datasource.ADataSource;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.ogr.FileOgrDataSource;
import com.northpool.resources.datasource.ogr.connection.FGDBOgrConnection;
import com.northpool.resources.datasource.ogr.connection.IOgrConnection;
import com.northpool.resources.datasource.ogr.pool.FGDBShellPool;
import com.northpool.resources.datasource.ogr.pool.OgrShellPool;
import java.io.IOException;

@ADataSource(name="fgdb", types="fgdb,gdb")
public class FGDBDataSource
extends FileOgrDataSource
implements IDataSource {
    public FGDBDataSource(String filePath) {
        super(filePath);
        this.dataSourceType = Constants.DATA_SOURCE_TYPE.fgdb;
    }

    public FGDBDataSource(String id, String filePath) {
        super(id, filePath);
        this.dataSourceType = Constants.DATA_SOURCE_TYPE.fgdb;
    }

    public IOgrConnection connection() throws IOException {
        return new FGDBOgrConnection(this, this.filePath);
    }

    @Override
    public OgrShellPool createOgrShellPool() {
        return new FGDBShellPool(this.filePath);
    }
}

