/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.ogr;

import com.northpool.resources.command.CommandImpl.SpatialCommand;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.ogr.IOgrShellDataSource;
import com.northpool.resources.datasource.ogr.connection.IOgrConnection;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.datatable.ogr.IOgrTransformer;
import com.northpool.resources.datatable.ogr.OgrScrollStatement;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.ogr.OgrDialect;
import com.northpool.resources.dialect.ogr.OgrQueryParmsDataInput;
import com.northpool.resources.sql.IQuery;
import com.northpool.spatial.Constants;
import com.northpool.spatial.Geom;
import com.northpool.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.Layer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OgrQuery<T>
implements IQuery<T, IOgrTransformer<T>> {
    OgrDialect dialect;
    IOgrTransformer<T> transformer;
    String sql;
    Map<String, Type> returnTypeMap = new HashMap<String, Type>();
    int firstResult = -1;
    int maxResults = -1;
    Integer fetchSize;
    List<Type> inputTypes = new ArrayList<Type>();
    IOgrShellDataSource ogrShellDataSource;
    boolean ignoreWarnings = false;
    static final Logger logger = LoggerFactory.getLogger(OgrQuery.class);
    List<Object> parameterList = new ArrayList<Object>();
    SpatialCommand command;
    ITable table;
    String[] queryFields;

    public OgrQuery(IDataSource dataSource, OgrDialect dialect, String sql, String[] queryFields, ITable table, SpatialCommand command) {
        this.ogrShellDataSource = (IOgrShellDataSource)dataSource;
        this.dialect = dialect;
        this.sql = sql;
        this.command = command;
        this.table = table;
        this.queryFields = queryFields;
    }

    public IQuery<T, IOgrTransformer<T>> setResultTransformer(IOgrTransformer<T> transformer) {
        this.transformer = transformer;
        return this;
    }

    public IQuery<T, IOgrTransformer<T>> addScalar(String key, Type type) {
        this.returnTypeMap.put(key, type);
        return this;
    }

    public IQuery<T, IOgrTransformer<T>> addScalar(Map<String, Type> returnTypeMap) {
        this.returnTypeMap = returnTypeMap;
        return this;
    }

    public IQuery<T, IOgrTransformer<T>> setParameter(int index, Object arg) {
        this.parameterList.add(index, arg);
        return this;
    }

    public IQuery<T, IOgrTransformer<T>> setFirstResult(Integer firstResult) {
        if (firstResult != null) {
            this.firstResult = firstResult;
        }
        return this;
    }

    public IQuery<T, IOgrTransformer<T>> setMaxResults(Integer maxResults) {
        if (maxResults != null) {
            this.maxResults = maxResults;
        }
        return this;
    }

    public IQuery<T, IOgrTransformer<T>> setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public IQuery<T, IOgrTransformer<T>> setParameters(Object[] args) {
        this.parameterList.addAll(Arrays.asList(args));
        return this;
    }

    public void setInputTypes(Type[] inputTypes) {
        if (inputTypes != null) {
            this.inputTypes = new ArrayList<Type>(Arrays.asList(inputTypes));
        }
    }

    public List<T> list() throws DataAccessException {
        long start = System.currentTimeMillis();
        IScroll<T> scroll = this.scroll();
        ArrayList<Object> list = new ArrayList<Object>();
        while (scroll.hasNext()) {
            Object next = scroll.next();
            if (next == null) continue;
            list.add(next);
        }
        return list;
    }

    protected void printSQL() {
        logger.debug(this.sql);
        logger.debug("use parameters:" + StringUtils.join(this.parameterList, (String)","));
    }

    private String setValuesIntoSql(String sql, Object[] args, Type[] types) {
        int size = args.length;
        if (args.length != types.length) {
            throw new RuntimeException("\u67e5\u8be2\u65f6\u503c\u7684\u957f\u5ea6\u9700\u8981\u548c\u7c7b\u578b\u7684\u957f\u5ea6\u4e00\u81f4");
        }
        ArrayList parmsList = new ArrayList();
        for (int i = 0; i < size; ++i) {
            OgrQueryParmsDataInput.INSTANCE.input(parmsList, types[i], args[i], i);
            sql = StringUtils.replaceOnce((String)sql, (String)"?", (String)((String)parmsList.get(i)));
        }
        return sql;
    }

    private Layer executeSQL(DataSource dataSource, String sql, SpatialCommand command) {
        Layer layer = null;
        if (command == null) {
            layer = dataSource.ExecuteSQL(sql);
        } else {
            command.build((IDialect)this.dialect);
            Geom geom = command.getGeometry();
            geom.changeType(Constants.SPATIAL_TYPE.gdalGeometry);
            sql = sql.replace("where null", "");
            layer = dataSource.ExecuteSQL(sql, (Geometry)geom.getOriginGeom());
        }
        return layer;
    }

    public IScroll<T> scroll() throws DataAccessException {
        IScroll scroll;
        this.printSQL();
        Object[] args = this.parameterList.toArray(new Object[this.parameterList.size()]);
        try {
            Type[] types = this.inputTypes.toArray(new Type[this.inputTypes.size()]);
            String sql = this.setValuesIntoSql(this.sql, args, types);
            IOgrConnection connection = (IOgrConnection)this.ogrShellDataSource.connection();
            DataSource dataSource = connection.getReadShell().getDataSource();
            OgrScrollStatement ogrScrollStatement = null;
            int whereIndex = sql.indexOf("where");
            String fidColumn = dataSource.GetLayer(this.table.getTablename()).GetFIDColumn();
            if (StringUtils.isEmpty((CharSequence)fidColumn)) {
                fidColumn = "FID";
            }
            Layer layer = null;
            if (whereIndex != -1 && sql.substring(whereIndex).indexOf("\"" + fidColumn + "\" in") != -1) {
                List<Long> fids = Arrays.stream(args).map(arg -> Long.valueOf(arg.toString())).collect(Collectors.toList());
                ogrScrollStatement = new OgrScrollStatement(this.table, this.queryFields, this.firstResult, this.maxResults, fids);
                layer = this.executeSQL(dataSource, sql, this.command);
            } else {
                ogrScrollStatement = new OgrScrollStatement(this.table, this.queryFields, this.firstResult, this.maxResults);
                layer = this.executeSQL(dataSource, sql, this.command);
            }
            scroll = this.transformer.extractDataScroll((IDialect)this.dialect, layer, this.returnTypeMap, ogrScrollStatement);
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
        return scroll;
    }
}

