/**
　 * <p>Title: FGDBDataSource.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年7月20日
　 * @version 1.0
*/
package com.northpool.resources.datasource.ogr;


import com.alibaba.fastjson.JSON;
import com.northpool.resources.datasource.AbstractDataSource;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.ogr.pool.OgrShellPoolManager;
import com.northpool.resources.datasource.ogr.shell.read.FGDBOgrReadShell;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;


/**
 * @author matt
 * 
 */
public abstract class FileOgrDataSource extends AbstractDataSource implements IDataSource, IOgrShellDataSource {


    protected String filePath;


    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public FileOgrDataSource(String filePath){
        this.filePath = filePath;
        if(this.id == null){
            this.id = this.processFileURL(filePath);
        }
    }


    public FileOgrDataSource(String id, String filePath){
        this.filePath = filePath;
        if(id == null){
            this.id = this.processFileURL(filePath);
        } else {
            this.id = id;
        }
    }

    private String processFileURL(String filePath){
        Path path = Paths.get(filePath);
        ArrayList<String> array = new ArrayList<>();
        Iterator<Path> iterator = path.iterator();
        while(iterator.hasNext()){
            array.add(iterator.next().toString());
        }
        return String.join("|", array);
    }


    FileOgrDataSource(){
        
    }
    
    @Override
    public String toJson() {
        // TODO Auto-generated method stub
        return JSON.toJSON(this).toString();
    }

    @Override
    public String mark() {
        // TODO Auto-generated method stub
        return new StringBuilder().append(this.dataSourceType.name()).append('_').append(this.processFileURL(this.filePath)).toString();
    }

    
    @Override
    public void testConnection() throws Exception {
        // TODO Auto-generated method stub
        FGDBOgrReadShell shell = new FGDBOgrReadShell(this.filePath);
        shell.load();
    
    }

 

    
    @Override
    public void resetConnection() {
        // TODO Auto-generated method stub
        
    }

    
    @Override
    public void destory() {
        // TODO Auto-generated method stub
        OgrShellPoolManager.getInstance().remove(this);
    }

    @Deprecated
    @Override
    public ResultSet getSqlQuery(String sql) {
        return null;
    }

    @Deprecated
    @Override
    public Boolean executeSqlCommand(String sql) {
        return null;
    }



}
