package com.northpool.resources.datasource.ogr.pool;

import com.northpool.resources.datasource.ogr.IOgrShellDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;

public class OgrShellPoolManager {

    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    protected static OgrShellPoolManager INSTANCE = new OgrShellPoolManager();

    protected static HashMap<String, OgrShellPool> POOL_CACHE = new HashMap<String, OgrShellPool>();


    public static OgrShellPoolManager getInstance() {
        return INSTANCE;
    }

    public OgrShellPool getOgrShellPool(IOgrShellDataSource dataSource) {
        OgrShellPool pool = POOL_CACHE.get(dataSource.mark());
        if (pool != null) {
            return pool;
        }
        synchronized (this) {
            pool = POOL_CACHE.get(dataSource.mark());
            if (pool != null) {
                return pool;
            }
            pool = dataSource.createOgrShellPool();
            POOL_CACHE.put(dataSource.mark(), pool);
            return pool;
        }
    }

    public synchronized void remove(IOgrShellDataSource dataSource) {
        OgrShellPool pool = POOL_CACHE.get(dataSource.mark());
        if (pool != null) {
            pool.close();
            POOL_CACHE.remove(dataSource.mark());
        }
    }
}

