/**
　 * <p>Title: AbstractGdbDAO.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年4月1日
　 * @version 1.0
*/
package com.northpool.resources.datatable.ogr;

import com.northpool.exception.UException;
import com.northpool.resources.command.CommandImpl.SpatialCommand;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IDAO;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.ogr.OgrDialect;
import com.northpool.resources.sql.IQuery;
import com.northpool.resources.sql.ISQLQueryEngine;
import com.northpool.resources.sql.SQLParameter;
import com.northpool.resources.sql.SQLQueryEngine;
import com.northpool.type.Type;

import java.util.List;
import java.util.Map;



/**
 * @author matt
 *
 */
public class AbstractOgrDAO<PK,T> implements IDAO<T,PK> {

    protected IDataSource dataSource;

    protected OgrDialect dialect;
    
    protected OgrTable ogrTable;
    
    protected Class<?> clazz;
    
    protected IOgrTransformer<T> transformer;
    
    
    
    public AbstractOgrDAO(IDataSource dataSource, OgrTable ogrTable, IOgrTransformer<T> transformer) {
        this.dataSource = dataSource;
        this.dialect = (OgrDialect)IDialect.getByType(dataSource.getDataSourceType());
        this.ogrTable = ogrTable;
        this.transformer = transformer;

    }

    @Override
    public T get(PK pk) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }

   
    @Override
    public Long count(QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }

   
    @Override
    public List<T> query(QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }

   
    @Override
    public List<T> query(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        ISQLQueryEngine engine = null;
        try {
            engine = new SQLQueryEngine(this.ogrTable,queryFilter).exceptSpatialFilter();
        } catch (Exception e) {
            UException.printStackTrace(e);
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();

        // IQuery<ST,IFGDBTransformer<?>> query = this.createQuery(parameter.getSql(), parameter.getValues(), parameter.getTypes(), queryFilter.getStart(), queryFilter.getEnd(), parameter.getReturnTypeMap(), transformer,parameter.getSpatialCommand());

        IQuery<T, IOgrTransformer<?>> query = this.createQuery(parameter.getSql(),parameter.getReturnFieldArray(), parameter.getValues(), parameter.getTypes(), queryFilter.getStart(), queryFilter.getEnd(), parameter.getReturnTypeMap(), transformer, parameter.getSpatialCommand());

        return query.list();
    }

    
    @Override
    public List<Object[]> queryArray(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        ISQLQueryEngine engine = null;
        try {
            engine = new SQLQueryEngine(this.ogrTable,queryFilter).exceptSpatialFilter();
        } catch (Exception e) {
            UException.printStackTrace(e);
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();

        // IQuery<ST,IFGDBTransformer<?>> query = this.createQuery(parameter.getSql(), parameter.getValues(), parameter.getTypes(), queryFilter.getStart(), queryFilter.getEnd(), parameter.getReturnTypeMap(), transformer,parameter.getSpatialCommand());

        IQuery<Object[], IOgrTransformer<?>> query = this.createQuery(parameter.getSql(),parameter.getReturnFieldArray(), parameter.getValues(), parameter.getTypes(), queryFilter.getStart(), queryFilter.getEnd(), parameter.getReturnTypeMap(), IOgrTransformer.ARRAY, parameter.getSpatialCommand());


        return query.list();
    }

    
    
    
    
    
    private <ST> IScroll<ST> _scroll(QueryFilter queryFilter, Integer fetchSize, IOgrTransformer<ST> transformer) throws DataAccessException {
        // TODO Auto-generated method stub
        
        ISQLQueryEngine engine = null;
        try {
             engine = new SQLQueryEngine(this.ogrTable,queryFilter).exceptSpatialFilter().doNotUseAliasName();
        } catch (Exception e) {
            UException.printStackTrace(e);
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        
       // IQuery<ST,IFGDBTransformer<?>> query = this.createQuery(parameter.getSql(), parameter.getValues(), parameter.getTypes(), queryFilter.getStart(), queryFilter.getEnd(), parameter.getReturnTypeMap(), transformer,parameter.getSpatialCommand());
        
        IQuery<ST, IOgrTransformer<?>> query = this.createQuery(parameter.getSql(),parameter.getReturnFieldArray(), parameter.getValues(), parameter.getTypes(), queryFilter.getStart(), queryFilter.getEnd(), parameter.getReturnTypeMap(), transformer, parameter.getSpatialCommand());
        
        
        return query.scroll();
    }

   
    @Override
    public IScroll<T> scroll(QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        return this.scroll(queryFilter, null);
    }

    
  
    
    @Override
    public IScroll<Object[]> scrollArray(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        return this._scroll(queryFilter, fetchSize, IOgrTransformer.ARRAY);
    }

    
    @Override
    public IScroll<Object> scrollId(QueryFilter filter, Integer fetchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }



   
    @Override
    public PK saveOrUpdate(T t) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }

   
    @Override
    public void remove(PK pk) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

   
    @Override
    public List<PK> update(T t) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public List<PK> update(T t, String[] includeFields) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void removeAll() throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

   
    @Override
    public List<PK> insertMany(List<T> list) throws DataAccessException {
        // TODO Auto-generated method stub
        return this.insertMany(list, IDAO.DEFALT_BATCH_SIZE);
    }

    @Override
    public List<PK> insertMany(List<T> list, Integer batchSize) throws DataAccessException {
        return null;
    }

    @Override
    public List<PK> insertMany(List<Object[]> list, String[] fields, Integer batchSize) throws DataAccessException {
        return null;
    }


    @Override
    public void updateMany(T o, QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

    
    @Override
    public void remove(QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#insert(java.lang.Object)
     */
    @Override
    public PK insert(T t) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }

    //先写,以后需要合并的方法
    private Type[] guessType(Object[] args) {
        Type[] types = new Type[args.length];
        for (int i = 0; i < args.length; i++) {
            Object arg = args[i];
            Type t = this.dialect.getTypeByObject(arg);
            types[i] = t;
        }
        return types;

    }
    
  
    
    
    @SuppressWarnings("rawtypes")
    protected <ST> IQuery<ST, IOgrTransformer<?>> createQuery(final String sql, final String[] selectFieldArray, final Object[] args, final Type[] types,
                                                              final Integer firstResult, final Integer maxResults, final Map<String, Type> returnType,
                                                              final IOgrTransformer<ST> transformer, final SpatialCommand command) throws DataAccessException {

        @SuppressWarnings("unchecked")
        IQuery<ST, IOgrTransformer<?>> query = new OgrQuery(this.dataSource, dialect, sql, selectFieldArray, ogrTable, command);
        query.setResultTransformer(transformer);

        query.addScalar(returnType);
        if (args != null) {
            Type[] inTypes;
            if (types == null) {
                inTypes = this.guessType(args);
            } else {
                inTypes = types;
            }
            query.setInputTypes(inTypes);
            query.setParameters(args);
        }

        query.setFirstResult(firstResult).setMaxResults(maxResults);

        return query;
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IQueryTable#scroll(com.northpool.resources.command.QueryFilter, java.lang.Integer)
     */
    @Override
    public IScroll scroll(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        return this._scroll(queryFilter, fetchSize, IOgrTransformer.MAP);
    }
    


   
   

    
    
    
    
    
   

}
