/**
　 * <p>Title: FGDBDataSource.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年7月20日
　 * @version 1.0
*/
package com.northpool.resources.datasource.ogr;


import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datasource.ADataSource;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.ogr.connection.FGDBOgrConnection;
import com.northpool.resources.datasource.ogr.connection.IOgrConnection;
import com.northpool.resources.datasource.ogr.pool.FGDBShellPool;
import com.northpool.resources.datasource.ogr.pool.OgrShellPool;

import java.io.IOException;


/**
 * @author matt
 * 
 */
@ADataSource(name = "fgdb" ,types = "fgdb,gdb")
public class FGDBDataSource extends FileOgrDataSource implements IDataSource {
    

    public FGDBDataSource(String filePath){
        super(filePath);
        this.dataSourceType = DATA_SOURCE_TYPE.fgdb;
    }
    
    
    public FGDBDataSource(String id,String filePath){
        super(id,filePath);
        this.dataSourceType = DATA_SOURCE_TYPE.fgdb;
    }

    @Override
    public IOgrConnection connection() throws IOException {
        return new FGDBOgrConnection(this, this.filePath);
    }


    @Override
    public OgrShellPool createOgrShellPool() {
        return new FGDBShellPool(this.filePath);
    }
}
