package com.northpool.resources.datasource.ogr.shell.read;

import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.exception.TableNotFoundException;
import org.gdal.ogr.DataSource;

import java.io.IOException;
import java.util.LinkedHashMap;

public interface IOgrReadShell {
    public void load() throws IOException;

    public void reload() throws IOException;

    public void close();

    public DataSource getDataSource();

    String[] getTables();

    boolean hasTable(String tableName);

    String geTableRemarks(String tableName) throws TableNotFoundException;

    LinkedHashMap<String, IColumn> getColumnMap(String tableName) throws TableNotFoundException;

}
