/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datasource.ogr.pool;

import com.northpool.resources.datasource.ogr.IOgrShellDataSource;
import com.northpool.resources.datasource.ogr.pool.OgrShellPool;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OgrShellPoolManager {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static OgrShellPoolManager INSTANCE = new OgrShellPoolManager();
    protected static HashMap<String, OgrShellPool> POOL_CACHE = new HashMap();

    public static OgrShellPoolManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OgrShellPool getOgrShellPool(IOgrShellDataSource dataSource) {
        OgrShellPool pool = POOL_CACHE.get(dataSource.mark());
        if (pool != null) {
            return pool;
        }
        OgrShellPoolManager ogrShellPoolManager = this;
        synchronized (ogrShellPoolManager) {
            pool = POOL_CACHE.get(dataSource.mark());
            if (pool != null) {
                return pool;
            }
            pool = dataSource.createOgrShellPool();
            POOL_CACHE.put(dataSource.mark(), pool);
            return pool;
        }
    }

    public synchronized void remove(IOgrShellDataSource dataSource) {
        OgrShellPool pool = POOL_CACHE.get(dataSource.mark());
        if (pool != null) {
            pool.close();
            POOL_CACHE.remove(dataSource.mark());
        }
    }
}

