/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.ogr;

import com.northpool.resources.datatable.ogr.AbstractOgrTransformer;
import com.northpool.resources.datatable.ogr.IOgrTransformer;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.sql.ResultSetMapping;
import com.northpool.type.Type;
import com.northpool.type.TypeOgrGeometry;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gdal.ogr.Feature;

public class ArrayOgrTransformer
extends AbstractOgrTransformer<Object[]>
implements IOgrTransformer<Object[]> {
    @Override
    protected ResultSetMapping<Object[], AbstractOgrTransformer.Cursor> getMapping() {
        return new ResultSetMapping<Object[], AbstractOgrTransformer.Cursor>(){

            public Object[] mapping(AbstractOgrTransformer.Cursor cursor, LinkedHashMap<String, Type> typeLink, IDialect dialect) {
                Feature feature = cursor.getValue();
                if (feature == null) {
                    return null;
                }
                IResourcesDataOutput output = dialect.getResourcesDataOutput();
                Object[] values = new Object[typeLink.entrySet().size()];
                Iterator<Map.Entry<String, Type>> iterator = typeLink.entrySet().iterator();
                int indexInQueryFieldArray = 0;
                int indexInDataOutput = 0;
                while (iterator.hasNext()) {
                    Type type = iterator.next().getValue();
                    Object object = null;
                    if (type.getEnum() != TypeOgrGeometry.INSTANCE.getEnum()) {
                        object = output.output((Object)feature, type, (Object)indexInDataOutput);
                        ++indexInDataOutput;
                    } else {
                        object = output.output((Object)feature, type, null);
                    }
                    values[indexInQueryFieldArray] = object;
                    ++indexInQueryFieldArray;
                }
                feature.delete();
                return values;
            }
        };
    }
}

