/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datasource.ogr;

import com.alibaba.fastjson.JSON;
import com.northpool.resources.datasource.AbstractDataSource;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.ogr.IOgrShellDataSource;
import com.northpool.resources.datasource.ogr.pool.OgrShellPoolManager;
import com.northpool.resources.datasource.ogr.shell.read.FGDBOgrReadShell;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class FileOgrDataSource
extends AbstractDataSource
implements IDataSource,
IOgrShellDataSource {
    protected String filePath;

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public FileOgrDataSource(String filePath) {
        this.filePath = filePath;
        if (this.id == null) {
            this.id = this.processFileURL(filePath);
        }
    }

    public FileOgrDataSource(String id, String filePath) {
        this.filePath = filePath;
        this.id = id == null ? this.processFileURL(filePath) : id;
    }

    private String processFileURL(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        ArrayList<String> array = new ArrayList<String>();
        Iterator<Path> iterator = path.iterator();
        while (iterator.hasNext()) {
            array.add(iterator.next().toString());
        }
        return String.join((CharSequence)"|", array);
    }

    FileOgrDataSource() {
    }

    public String toJson() {
        return JSON.toJSON((Object)this).toString();
    }

    public String mark() {
        return this.dataSourceType.name() + '_' + this.processFileURL(this.filePath);
    }

    public void testConnection() throws Exception {
        FGDBOgrReadShell shell = new FGDBOgrReadShell(this.filePath);
        shell.load();
    }

    public void resetConnection() {
    }

    public void destory() {
        OgrShellPoolManager.getInstance().remove(this);
    }

    @Deprecated
    public ResultSet getSqlQuery(String sql) {
        return null;
    }

    @Deprecated
    public Boolean executeSqlCommand(String sql) {
        return null;
    }
}

