/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.ogr;

import com.northpool.exception.UException;
import com.northpool.resources.datatable.SpatialInfo;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.datatable.ogr.OgrScrollStatement;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.ogr.OgrDialect;
import com.northpool.resources.sql.ResultSetMapping;
import com.northpool.type.Type;
import com.northpool.type.TypeInteger;
import com.northpool.type.TypeOgrGeometry;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gdal.ogr.Feature;
import org.gdal.ogr.Layer;

public abstract class AbstractOgrTransformer<T> {
    LinkedHashMap<String, Type> createTypeLinkedMap(Layer layer, Map<String, Type> typeMap, IDialect dialect, String[] queryFieldArray, String spatialFieldName, String idFieldName) throws DataAccessException {
        LinkedHashMap<String, Type> typeLink = new LinkedHashMap<String, Type>();
        try {
            int i;
            int columnCount = layer.GetLayerDefn().GetFieldCount();
            if (typeMap == null) {
                typeMap = new HashMap<String, Type>();
            }
            LinkedHashMap<String, Type> newTypeMap = new LinkedHashMap<String, Type>();
            for (i = 0; i < columnCount; ++i) {
                String name = layer.GetLayerDefn().GetFieldDefn(i).GetName();
                String typeName = layer.GetLayerDefn().GetFieldDefn(i).GetTypeName();
                Type type = typeMap.get(typeName);
                if (type == null) {
                    type = dialect.getTypeByName(typeName);
                }
                newTypeMap.put(name, type);
            }
            for (i = 0; i < queryFieldArray.length; ++i) {
                String fieldName = queryFieldArray[i];
                Type type = (Type)newTypeMap.get(fieldName);
                if (type == null) {
                    if (fieldName.equals(spatialFieldName)) {
                        typeLink.put(spatialFieldName, TypeOgrGeometry.INSTANCE);
                        continue;
                    }
                    if (fieldName.equals(idFieldName)) {
                        typeLink.put(idFieldName, (Type)TypeInteger.INSTANCE);
                        continue;
                    }
                    throw new RuntimeException("\u67e5\u8be2\u7ed3\u679c\u627e\u4e0d\u5230\u5b57\u6bb5 " + fieldName + " \u7684\u5bf9\u5e94\u7c7b\u578b");
                }
                typeLink.put(fieldName, type);
            }
            return typeLink;
        }
        catch (Exception e) {
            UException.printStackTrace((Throwable)e);
            throw new DataAccessException(e);
        }
    }

    protected abstract ResultSetMapping<T, Cursor> getMapping();

    public List<T> extractData(OgrDialect dialect, Layer rs, Map<String, Type> typeMap) throws DataAccessException {
        return null;
    }

    public IScroll<T> extractDataScroll(final OgrDialect dialect, final Layer layer, Map<String, Type> typeMap, OgrScrollStatement scrollStatement) throws DataAccessException {
        int firstResult = scrollStatement.getFirstResult();
        int maxResults = scrollStatement.getMaxResults();
        final Cursor cursor = new Cursor();
        final ResultSetMapping<T, Cursor> mapping = this.getMapping();
        SpatialInfo spatialInfo = scrollStatement.getTable().spatialInfo();
        String spatialFieldName = null;
        if (spatialInfo != null) {
            spatialFieldName = spatialInfo.getSpatialField();
        }
        String idField = scrollStatement.getTable().getIdField();
        final LinkedHashMap<String, Type> typeMapLink = this.createTypeLinkedMap(layer, typeMap, (IDialect)dialect, scrollStatement.queryFields, spatialFieldName, idField);
        if (firstResult != -1) {
            while (cursor.getCursorIndex() < firstResult) {
                layer.GetNextFeature();
                cursor.cursorIndexGoNext();
            }
        }
        if (scrollStatement.getFids() != null) {
            final Iterator<Long> iterator = scrollStatement.getFids().iterator();
            IScroll scroll = new IScroll<T>(){

                public boolean hasNext() {
                    boolean hasNext = iterator.hasNext();
                    if (hasNext) {
                        Feature feature = layer.GetFeature(((Long)iterator.next()).longValue());
                        cursor.cursorIndexGoNext();
                        cursor.setValue(feature);
                    }
                    return hasNext;
                }

                public T next() {
                    Object t = mapping.mapping((Object)cursor, typeMapLink, (IDialect)dialect);
                    return t;
                }

                public void close() throws IOException {
                    layer.delete();
                }
            };
            return scroll;
        }
        IScroll scroll = new IScroll<T>(){

            public boolean hasNext() {
                try {
                    Feature feature = layer.GetNextFeature();
                    if (feature == null && layer.GetFeaturesRead() == 0L) {
                        layer.ResetReading();
                        feature = layer.GetNextFeature();
                        System.out.println("reset reading");
                    }
                    if (feature == null) {
                        return false;
                    }
                    cursor.cursorIndexGoNext();
                    cursor.setValue(feature);
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    UException.printStackTrace((Throwable)e);
                    throw new DataAccessException(e);
                }
            }

            public T next() {
                Object t = mapping.mapping((Object)cursor, typeMapLink, (IDialect)dialect);
                return t;
            }

            public void close() throws IOException {
                layer.delete();
            }
        };
        return scroll;
    }

    public static void main(String[] args) {
        Long a = 1L;
        int b = 1;
        System.out.println(a.intValue() == b);
    }

    public class Cursor {
        int cursorIndex = 0;
        Feature value;

        public int getCursorIndex() {
            return this.cursorIndex;
        }

        public void setValue(Feature value) {
            this.value = value;
        }

        public Feature getValue() {
            return this.value;
        }

        public void cursorIndexGoNext() {
            ++this.cursorIndex;
        }
    }
}

