package com.northpool.resources.datasource.spark;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datasource.ADataSource;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datatable.AbstractTable;
import com.northpool.resources.datatable.FieldEncoder;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.operate.ITableOperator;
import com.northpool.resources.datatable.operate.TableOperatorManager;
import com.northpool.resources.datatable.operate.TableSchemaBean;
import com.northpool.resources.utils.spark.HttpUtils;
import com.northpool.resources.utils.spark.SparkMapResponseHandler;
import com.northpool.resources.utils.spark.SparkResponseHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author matt
 *
 */
@ADataSource(name = "spark" ,types = "spark")
public class SparkDataSource implements IDataSource {

    protected String url;
    
    protected String id;

    protected String version;

    ThreadLocal<List<Object[]>> threadLocal = new ThreadLocal<>();

    public SparkDataSource(String url, String id){
        this.url = url;
        this.id = id;
    }
    
    public String toJson() {
        // TODO Auto-generated method stub
        return JSON.toJSON(this).toString();
    }

   
    public String mark() {
        // TODO Auto-generated method stub
        return url;
    }

   
    public String getId() {
        // TODO Auto-generated method stub
        return this.id;
    }

    
    public DATA_SOURCE_TYPE getDataSourceType() {
        // TODO Auto-generated method stub
        return DATA_SOURCE_TYPE.spark;
    }

  
    public IDataSource createByJson(String json) {
        // TODO Auto-generated method stub
        return JSON.parseObject(json, SparkDataSource.class);
    }

    public List<Object[]> query(ITable table, String sqlFilter, Integer srid, String wkt, List<String> fieldNames, String idField) throws Exception {
        if (threadLocal.get() != null){
            List<Object[]> result = threadLocal.get();
            threadLocal.remove();
            return result;
        }
        String tableName = table.getTablename();
        WKTReader reader = new WKTReader();
        Geometry geometry = reader.read(wkt);
        Envelope envelope = geometry.getEnvelopeInternal();
        Double res = (envelope.getMaxX() - envelope.getMinX()) / 256;
        if (res < 0.0006866455078125){//低级别根据分辨率返回格子，不返回实体数据
            res = null;
        }
        List<Object[]> result = new ArrayList<>();
        String[] paras = new String[]{"baselayer", "range", "srid", "queryTerms", "savefields", "cellSize"};
        String[] values = new String[]{tableName, wkt, srid.toString(), sqlFilter, StringUtils.join(fieldNames, ","), res+""};
        JSONObject bodyObj = new JSONObject();
        for (int i = 0; i < paras.length; i++) {
            bodyObj.put(paras[i], values[i]);
        }
        String url = this.url + "/query";
        HttpPost post = HttpUtils.buildPostBodyRequest(url, bodyObj.toJSONString());
        CloseableHttpClient client = HttpUtils.getHttpClient();
        ResponseHandler<List<Object[]>> responseHandler = new SparkResponseHandler(idField.toUpperCase(), fieldNames);
        try{
            result = client.execute(post, responseHandler);
        }catch (Exception e){
            e.printStackTrace();
            throw e;
        }
        if (sqlFilter.indexOf("limit 1") == -1){
            if (!result.isEmpty()){
                threadLocal.set(result);
            }
        }

        return result;
    }

    public List<Map<String, ?>> queryForMap(ITable table, String sqlFilter, Integer srid, String wkt, List<String> fieldNames) throws Exception {
        String tableName = table.getTablename();
        List<Map<String, ?>> result = new ArrayList<>();
        String[] paras = new String[]{"baselayer", "range", "srid", "queryTerms", "savefields", "cellSize"};
        String[] values = new String[]{tableName, wkt, srid.toString(), sqlFilter, StringUtils.join(fieldNames, ","), null};
        JSONObject bodyObj = new JSONObject();
        for (int i = 0; i < paras.length; i++) {
            bodyObj.put(paras[i], values[i]);
        }
        String url = this.url + "/query";
        HttpPost post = HttpUtils.buildPostBodyRequest(url, bodyObj.toJSONString());
        CloseableHttpClient client = HttpUtils.getHttpClient();
        ResponseHandler<List<Map<String, ?>>> responseHandler = new SparkMapResponseHandler(((AbstractTable)table).getFieldsInTableMap());
        try{
            result = client.execute(post, responseHandler);
        }catch (Exception e){
            e.printStackTrace();
            throw e;
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    public File connection() throws Exception {
        // TODO Auto-generated method stub
        File dir = new File(this.url);
        if(!dir.exists()){
            throw new RuntimeException(String.format("地址%s不存在", this.url));
        }
        if(!dir.isDirectory()){
            throw new RuntimeException(String.format("地址%s不是文件夹", this.url));
        }
        return dir;
    }

   
    public void resetConnection() {
        // TODO Auto-generated method stub
        
    }

    
    public void destory() {
        // TODO Auto-generated method stub
        
    }

    @Override
    public ITableOperator getTableOperator(String tableName) throws Exception {
        return null;
    }


    public ITableOperator getTableBuilder(String tableName) throws Exception {
        // TODO Auto-generated method stub
        return TableOperatorManager.getInstance().getTableOperator(this, tableName,null);
    }

    @Override
    public void testConnection() throws Exception {

    }


    public ITable getTable(String tableName) throws Exception {
        // TODO Auto-generated method stub
        return this.getTableBuilder(tableName).getTable();
    }

    
    public ITable getTable(String tableName, FieldEncoder fieldEncoder) throws Exception {
        // TODO Auto-generated method stub
        return this.getTableBuilder(tableName).getTable(fieldEncoder);
    }

   
    public ITable getTable(String tableName, String[] selectFields) throws Exception {
        // TODO Auto-generated method stub
        return this.getTableBuilder(tableName).getTable(selectFields);
    }

    @Override
    public String[] tables() {
        throw new UnsupportedOperationException();
    }


    public String[] getTables() {
        // TODO Auto-generated method stub
        return null;
    }

  
    public void drop(String tableName) {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException();

    }

    @Override
    public void createTableBySchemaBean(TableSchemaBean schemaBean) {

    }


    @Override
    public Boolean hasSchema(String schema) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean hasTable(String tableName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }


    public ITableOperator createTableByBuilderBean(TableSchemaBean tableBean) {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException();
    }





    public String getUrl() {
        return url;
    }
}
