package com.northpool.resources.datatable.spark;

import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datasource.spark.SparkDataSource;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IMapDAO;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.datatable.db.AbstractDBDAO;
import com.northpool.resources.dialect.spark.SparkSQLDialect;
import com.northpool.resources.sql.QueryFilterToSQL;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SparkPersistDaoImpl<PK> extends AbstractDBDAO<PK,Map<String,?>> implements IMapDAO<PK> {

	protected SparkTable dbTable;

    SparkDataSource dbDataSource;

	public SparkPersistDaoImpl(SparkDataSource dbDataSource, SparkTable table) {
        super(dbDataSource, table, null);
        this.dbDataSource = dbDataSource;
		this.dbTable = table;
	}
	
	protected void checkWriteable(){
		if(dbTable.getIsView()){
			throw new RuntimeException(dbTable.mark() + "为试图,不能执行写操作");
		}
	}



	@Override
	public void remove(QueryFilter filter) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public List<Object[]> queryArray(QueryFilter filter, Integer fetchSize) {
		// TODO Auto-generated method stub
        List<String> filedNames = filter.getOutputFieldNames();
        filedNames = filedNames.stream().map(name -> dbTable.getFieldsMap().get(name).getOriginFieldName()).collect(Collectors.toList());;
        filedNames.remove("SHAPE");//去掉空间字段，spark默认返回
        String sqlFilter = null;
        QueryFilterToSQL queryFilterToSQL = new QueryFilterToSQL(filter, SparkSQLDialect.INSTANCE, dbTable.fieldsTypeMap(), dbTable.fieldDecoder(),false);
        QueryFilterToSQL.WherePartSQL wherePart = queryFilterToSQL.toWherePartSQL();
        sqlFilter = wherePart.getWherePart();
        if (sqlFilter.indexOf("and") != -1){
            sqlFilter = sqlFilter.substring(sqlFilter.indexOf("and") + 4);//去掉空间查询的部分
        }else {
            sqlFilter = "";
        }

        if (filter.getLimit() != null && filter.getLimit() == 1){
            sqlFilter += " limit " + filter.getLimit();
        }
        List<Object> paras = wherePart.getValues();
        String wkt = null;
        if (paras.size() >= 2){
            wkt = paras.get(0).toString();
            paras = paras.subList(2, paras.size());
        }
        Object[] parasArr = paras.toArray();
        sqlFilter = sqlFilter.replace("?", "'%s'");
        sqlFilter = sqlFilter.replace("\"", "");
        sqlFilter = String.format(sqlFilter, parasArr);

        Integer srid = filter.getSRID();
        List<Object[]> list = null;
        try {
            list = this.dbDataSource.query(dbTable, sqlFilter, srid, wkt, filedNames, dbTable.getIdField());
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return list;
	}

    @Override
    public IScroll<Map<String, ?>> scroll(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        return null;
    }

    @Override
    public IScroll<Map<String, ?>> scroll(QueryFilter queryFilter) throws DataAccessException {
        return null;
    }

    @Override
    public IScroll<Object[]> scrollArray(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        return null;
    }

    @Override
    public IScroll<Object> scrollId(QueryFilter filter, Integer fetchSize) throws DataAccessException {
        return null;
    }

    public void insertManyDataMap(final List<Map<String, ?>> list,final Integer batchSize) throws DataAccessException {
	}


	@Override
	public List<Map<String, ?>> query(QueryFilter filter, Integer fetchSize) {
        List<String> filedNames = filter.getOutputFieldNames();
        if (filedNames.isEmpty()){
            filedNames = Arrays.asList(dbTable.getFields());
        }
        boolean containsShape = filedNames.contains("shape");
        filedNames = filedNames.stream().map(name -> dbTable.getFieldsMap().get(name).getOriginFieldName()).collect(Collectors.toList());;
        if (containsShape){
            filedNames.remove("SHAPE");//去掉空间字段，spark默认返回
        }
        String sqlFilter = null;
        QueryFilterToSQL queryFilterToSQL = new QueryFilterToSQL(filter, SparkSQLDialect.INSTANCE, dbTable.fieldsTypeMap(), dbTable.fieldDecoder(), false);
        QueryFilterToSQL.WherePartSQL wherePart = queryFilterToSQL.toWherePartSQL();
        sqlFilter = wherePart.getWherePart();
        if (sqlFilter.indexOf("and") != -1){
            sqlFilter = sqlFilter.substring(sqlFilter.indexOf("and") + 4);//去掉空间查询的部分
        }else {
            sqlFilter = "";
        }

        if (filter.getLimit() != null && filter.getLimit() == 1){
            sqlFilter += " limit " + filter.getLimit();
        }
        List<Object> paras = wherePart.getValues();
        String wkt = null;
        if (paras.size() >= 2){
            wkt = paras.get(0).toString();
            paras = paras.subList(2, paras.size());
        }
        Object[] parasArr = paras.toArray();
        sqlFilter = sqlFilter.replace("?", "'%s'");
        sqlFilter = sqlFilter.replace("\"", "");
        sqlFilter = String.format(sqlFilter, parasArr);

        Integer srid = filter.getSRID();
        List<Map<String, ?>> list = null;
        try {
            list = this.dbDataSource.queryForMap(dbTable, sqlFilter, srid, wkt, filedNames);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!containsShape){
            list.stream().forEach(item -> item.remove("shape"));
        }
        return list;
	}

  

    @Override
    public Long count(QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public List<Map<String, ?>> query(QueryFilter queryFilter) throws DataAccessException {
        return null;
    }


    @Override
    public void insert(Map<String, ?> stringMap) throws DataAccessException {

    }

    @Override
    public void saveOrUpdate(Map<String, ?> stringMap) throws DataAccessException {

    }


    @Override
    public void update(Map<String, ?> stringMap) throws DataAccessException {

    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#removeAll()
     */
    @Override
    public void removeAll() throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void insertMany(List<Map<String, ?>> list) throws DataAccessException {

    }

    @Override
    public void insertMany(List<Map<String, ?>> list, Integer batchSize) throws DataAccessException {

    }




    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#updateMany(java.util.Map, com.northpool.resources.command.QueryFilter)
     */
    @Override
    public void updateMany(Map<String, ?> m, QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }


    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#insertMany(java.util.List, java.lang.String[], java.lang.Integer)
     */
    @Override
    public void insertMany(List<Object[]> list, String[] fields, Integer batchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }


}
