/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datasource.spark;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.northpool.resources.Constants;
import com.northpool.resources.datasource.ADataSource;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datatable.AbstractTable;
import com.northpool.resources.datatable.FieldEncoder;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.operate.ITableOperator;
import com.northpool.resources.datatable.operate.TableOperatorManager;
import com.northpool.resources.datatable.operate.TableSchemaBean;
import com.northpool.resources.utils.spark.HttpUtils;
import com.northpool.resources.utils.spark.SparkMapResponseHandler;
import com.northpool.resources.utils.spark.SparkResponseHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;

@ADataSource(name="spark", types="spark")
public class SparkDataSource
implements IDataSource {
    protected String url;
    protected String id;
    protected String version;
    ThreadLocal<List<Object[]>> threadLocal = new ThreadLocal();

    public SparkDataSource(String url, String id) {
        this.url = url;
        this.id = id;
    }

    public String toJson() {
        return JSON.toJSON((Object)this).toString();
    }

    public String mark() {
        return this.url;
    }

    public String getId() {
        return this.id;
    }

    public Constants.DATA_SOURCE_TYPE getDataSourceType() {
        return Constants.DATA_SOURCE_TYPE.spark;
    }

    public IDataSource createByJson(String json) {
        return (IDataSource)JSON.parseObject((String)json, SparkDataSource.class);
    }

    public List<Object[]> query(ITable table, String sqlFilter, Integer srid, String wkt, List<String> fieldNames, String idField) throws Exception {
        if (this.threadLocal.get() != null) {
            List<Object[]> result = this.threadLocal.get();
            this.threadLocal.remove();
            return result;
        }
        String tableName = table.getTablename();
        WKTReader reader = new WKTReader();
        Geometry geometry = reader.read(wkt);
        Envelope envelope = geometry.getEnvelopeInternal();
        Double res = (envelope.getMaxX() - envelope.getMinX()) / 256.0;
        if (res < 6.866455078125E-4) {
            res = null;
        }
        List<Object[]> result = new ArrayList();
        String[] paras = new String[]{"baselayer", "range", "srid", "queryTerms", "savefields", "cellSize"};
        String[] values = new String[]{tableName, wkt, srid.toString(), sqlFilter, StringUtils.join(fieldNames, (String)","), res + ""};
        JSONObject bodyObj = new JSONObject();
        for (int i = 0; i < paras.length; ++i) {
            bodyObj.put(paras[i], (Object)values[i]);
        }
        String url = this.url + "/query";
        HttpPost post = HttpUtils.buildPostBodyRequest(url, bodyObj.toJSONString());
        CloseableHttpClient client = HttpUtils.getHttpClient();
        SparkResponseHandler responseHandler = new SparkResponseHandler(idField.toUpperCase(), fieldNames);
        try {
            result = (List)client.execute((HttpUriRequest)post, (ResponseHandler)responseHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        if (sqlFilter.indexOf("limit 1") == -1 && !result.isEmpty()) {
            this.threadLocal.set(result);
        }
        return result;
    }

    public List<Map<String, ?>> queryForMap(ITable table, String sqlFilter, Integer srid, String wkt, List<String> fieldNames) throws Exception {
        String tableName = table.getTablename();
        ArrayList<Map<String, ?>> result = new ArrayList();
        String[] paras = new String[]{"baselayer", "range", "srid", "queryTerms", "savefields", "cellSize"};
        String[] values = new String[]{tableName, wkt, srid.toString(), sqlFilter, StringUtils.join(fieldNames, (String)","), null};
        JSONObject bodyObj = new JSONObject();
        for (int i = 0; i < paras.length; ++i) {
            bodyObj.put(paras[i], (Object)values[i]);
        }
        String url = this.url + "/query";
        HttpPost post = HttpUtils.buildPostBodyRequest(url, bodyObj.toJSONString());
        CloseableHttpClient client = HttpUtils.getHttpClient();
        SparkMapResponseHandler responseHandler = new SparkMapResponseHandler(((AbstractTable)table).getFieldsInTableMap());
        try {
            result = (List)client.execute((HttpUriRequest)post, (ResponseHandler)responseHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return result;
    }

    public File connection() throws Exception {
        File dir = new File(this.url);
        if (!dir.exists()) {
            throw new RuntimeException(String.format("\u5730\u5740%s\u4e0d\u5b58\u5728", this.url));
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException(String.format("\u5730\u5740%s\u4e0d\u662f\u6587\u4ef6\u5939", this.url));
        }
        return dir;
    }

    public void resetConnection() {
    }

    public void destory() {
    }

    public ITableOperator getTableOperator(String tableName) throws Exception {
        return null;
    }

    public ITableOperator getTableBuilder(String tableName) throws Exception {
        return TableOperatorManager.getInstance().getTableOperator((IDataSource)this, tableName, null);
    }

    public void testConnection() throws Exception {
    }

    public ITable getTable(String tableName) throws Exception {
        return this.getTableBuilder(tableName).getTable();
    }

    public ITable getTable(String tableName, FieldEncoder fieldEncoder) throws Exception {
        return this.getTableBuilder(tableName).getTable(fieldEncoder);
    }

    public ITable getTable(String tableName, String[] selectFields) throws Exception {
        return this.getTableBuilder(tableName).getTable(selectFields);
    }

    public String[] tables() {
        throw new UnsupportedOperationException();
    }

    public String[] getTables() {
        return null;
    }

    public void drop(String tableName) {
        throw new UnsupportedOperationException();
    }

    public void createTableBySchemaBean(TableSchemaBean schemaBean) {
    }

    public Boolean hasSchema(String schema) {
        throw new UnsupportedOperationException();
    }

    public Boolean hasTable(String tableName) {
        throw new UnsupportedOperationException();
    }

    public String getVersion() {
        return null;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ITableOperator createTableByBuilderBean(TableSchemaBean tableBean) {
        throw new UnsupportedOperationException();
    }

    public String getUrl() {
        return this.url;
    }
}

