/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.utils.spark;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.util.UTF8Decoder;
import com.northpool.resources.datatable.IField;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.wkb.WkbDecoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.xerial.snappy.Snappy;

public class SparkMapResponseHandler
implements ResponseHandler<List<Map<String, ?>>> {
    private final Map<String, IField> fieldsInTableMap;

    public SparkMapResponseHandler(Map<String, IField> fieldsInTableMap) {
        this.fieldsInTableMap = fieldsInTableMap;
    }

    public List<Map<String, ?>> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        ArrayList result = new ArrayList();
        HttpEntity entity = response.getEntity();
        if (200 != response.getStatusLine().getStatusCode()) {
            String message = EntityUtils.toString((HttpEntity)entity);
            if (message.contains("key not found:")) {
                return result;
            }
            throw new ClientProtocolException(message);
        }
        byte[] allData = EntityUtils.toByteArray((HttpEntity)entity);
        ByteBuffer byteBuffer = ByteBuffer.wrap(allData);
        int len = byteBuffer.getInt();
        byte[] buff = this.getBytesByLength(byteBuffer, len);
        byte[] propByte = Snappy.uncompress((byte[])buff);
        JSONArray array = (JSONArray)JSON.parse((byte[])propByte, (int)0, (int)propByte.length, (CharsetDecoder)new UTF8Decoder(), (Feature[])new Feature[0]);
        int offsetLen = byteBuffer.getInt();
        byte[] offsetByte = this.getBytesByLength(byteBuffer, offsetLen);
        int featureNum = offsetLen / 4;
        ByteBuffer offsetBuffer = ByteBuffer.wrap(offsetByte);
        int feaLen = 0;
        Object bin = null;
        JSONObject item = null;
        HashMap<String, Object> feaMap = null;
        String key = null;
        for (int i = 0; i < featureNum; ++i) {
            item = array.getJSONObject(i);
            feaLen = offsetBuffer.getInt();
            byte[] fea = this.getBytesByLength(byteBuffer, feaLen);
            GeoBuffer buffer = null;
            try {
                buffer = WkbDecoder.DECODER.toGeoBuffer(fea);
            }
            catch (Exception e) {
                throw new ClientProtocolException((Throwable)e);
            }
            Iterator iterator = item.keySet().iterator();
            feaMap = new HashMap<String, Object>(item.size());
            while (iterator.hasNext()) {
                key = (String)iterator.next();
                feaMap.put(this.fieldsInTableMap.get(key).getFieldName(), item.get((Object)key));
            }
            feaMap.put("shape", buffer);
            result.add(feaMap);
        }
        return result;
    }

    private byte[] getBytesByLength(ByteBuffer byteBuffer, int len) throws IOException {
        byte[] buff = new byte[len];
        byteBuffer.get(buff, 0, len);
        return buff;
    }
}

