/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.utils.spark;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.util.UTF8Decoder;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.wkb.WkbDecoder;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.xerial.snappy.Snappy;

public class SparkResponseHandler
implements ResponseHandler<List<Object[]>> {
    String idField;
    List<String> fields;

    public SparkResponseHandler(String idField, List<String> fields) {
        this.idField = idField;
        this.fields = fields;
    }

    public List<Object[]> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        HttpEntity entity = response.getEntity();
        if (200 != response.getStatusLine().getStatusCode()) {
            String message = EntityUtils.toString((HttpEntity)entity);
            if (message.contains("key not found:")) {
                return result;
            }
            throw new ClientProtocolException(message);
        }
        byte[] allData = EntityUtils.toByteArray((HttpEntity)entity);
        ByteBuffer byteBuffer = ByteBuffer.wrap(allData);
        int len = byteBuffer.getInt();
        byte[] buff = this.getBytesByLength(byteBuffer, len);
        byte[] propByte = Snappy.uncompress((byte[])buff);
        JSONArray array = (JSONArray)JSON.parse((byte[])propByte, (int)0, (int)propByte.length, (CharsetDecoder)new UTF8Decoder(), (Feature[])new Feature[0]);
        int propSize = this.fields.size();
        int offsetLen = byteBuffer.getInt();
        byte[] offsetByte = this.getBytesByLength(byteBuffer, offsetLen);
        int featureNum = offsetLen / 4;
        ByteBuffer offsetBuffer = ByteBuffer.wrap(offsetByte);
        int feaLen = 0;
        Object bin = null;
        JSONObject item = null;
        for (int i = 0; i < featureNum; ++i) {
            feaLen = offsetBuffer.getInt();
            byte[] fea = this.getBytesByLength(byteBuffer, feaLen);
            GeoBuffer buffer = null;
            try {
                buffer = WkbDecoder.DECODER.toGeoBuffer(fea);
            }
            catch (Exception e) {
                throw new ClientProtocolException((Throwable)e);
            }
            Object[] props = new Object[propSize + 1];
            item = array.getJSONObject(i);
            props[0] = item.get((Object)this.idField);
            int size = item.size();
            int index = 1;
            String key2 = null;
            for (String key2 : this.fields) {
                if (key2.equals(this.idField)) continue;
                props[index] = item.get((Object)key2);
                ++index;
            }
            props[size] = buffer;
            result.add(props);
        }
        return result;
    }

    private byte[] getBytesByLength(ByteBuffer byteBuffer, int len) throws IOException {
        byte[] buff = new byte[len];
        byteBuffer.get(buff, 0, len);
        return buff;
    }

    private byte[] getBytesByLength(DataInputStream dataInputStream, int len) throws IOException {
        int splitLen = len > 1024 ? 1024 : len;
        byte[] tmpbuffer = new byte[splitLen];
        int surplus = len;
        int readLen = 0;
        byte[] buff = new byte[len];
        ByteBuffer byteBuffer = ByteBuffer.wrap(buff);
        while ((readLen = dataInputStream.read(tmpbuffer, 0, splitLen)) >= 0 && surplus > 0) {
            byteBuffer.put(tmpbuffer, 0, readLen);
            if ((surplus -= readLen) >= splitLen) continue;
            splitLen = surplus;
        }
        return buff;
    }
}

