package com.northpool.resources.datatablebuilder.spark.column;

import com.northpool.resources.datatable.operate.AbstractColumn;
import com.northpool.resources.datatable.operate.FieldDefaultValueBean;
import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.dialect.IDialect;
import com.northpool.spatial.Constants;
import com.northpool.type.Types;

public class SparkColumn extends AbstractColumn implements IColumn {
    public SparkColumn(String columnName, Integer columnSize, Integer digits, String columnTypeName, Boolean nullable, String defaultValue, String remarks, IDialect dialect) {
        super(columnName, columnSize, digits, columnTypeName, nullable, defaultValue, remarks, dialect);
    }

    @Override
    protected void initAttType() {

        if (columnTypeName.equals("geometry")){
            this.isSpatial = true;
            this.geoType = com.northpool.spatial.Constants.GEO_TYPE.MULTIPOLYGON;
        }else if (columnTypeName.equals("string")){
            this.type = Types.STRING;
        }else if (columnTypeName.equals("number")){
            this.type = Types.BIGDECIMAL;
        }

    }

    @Override
    protected FieldDefaultValueBean getFieldDefaultValueByDefaultValue() {
        return null;
    }

    @Override
    public Constants.SPATIAL_TYPE getSpatialType() {
        return null;
    }
}
