package com.northpool.resources.utils.spark;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.UTF8Decoder;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.wkb.WkbDecoder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.xerial.snappy.Snappy;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SparkResponseHandler implements ResponseHandler<List<Object[]>> {

    String idField;


    List<String> fields;

    public SparkResponseHandler(String idField, List<String> fields){
        this.idField = idField;
        this.fields = fields;
    }
    /*@Override
    public List<Object[]> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        InputStream in = null;
        DataInputStream dataInputStream = null;
        List<Object[]> result = new ArrayList<>();
        try{
            HttpEntity entity = response.getEntity();
            if (HttpStatus.SC_OK != response.getStatusLine().getStatusCode()) {
                String message = EntityUtils.toString(entity);
                if (message.contains("key not found:")){
                    return result;
                }else {
                    throw new ClientProtocolException(message);
                }
            }
            in =  entity.getContent();
            dataInputStream = new DataInputStream(in);
            int len = dataInputStream.readInt();
            byte[] buff = getBytesByLength(dataInputStream, len);
            byte[] propByte = Snappy.uncompress(buff);
            JSONArray array = (JSONArray) JSON.parse(propByte, 0, propByte.length, new UTF8Decoder());
            int propSize = 0;
            if (!array.isEmpty()){
                propSize = array.getJSONObject(0).size();
            }
            int offsetLen = dataInputStream.readInt();

            byte[] offsetByte = this.getBytesByLength(dataInputStream, offsetLen);
            int featureNum = offsetLen / 4;
            ByteBuffer offsetBuffer= ByteBuffer.wrap(offsetByte);
            int feaLen = 0;
            ByteArrayInputStream bin = null;
            JSONObject item = null;
            for (int i = 0; i < featureNum; i++) {
                feaLen = offsetBuffer.getInt();
                byte[] fea = this.getBytesByLength(dataInputStream, feaLen);
                bin = new ByteArrayInputStream(fea);
                GeoBuffer buffer = null;
                try {
                    buffer = WkbDecoder.decoder().toGeoBuffer(bin);
                } catch (Exception e) {
                    throw new ClientProtocolException(e);
                }
                Object[] props = new Object[propSize + 1];
                item = array.getJSONObject(i);
                props[0] = item.get(idField);
                int size = item.size();
                int index = 1;
                Iterator<String> keyInterator = item.keySet().iterator();
                while (keyInterator.hasNext()){
                    String key = keyInterator.next();
                    if (key.equals(idField)){
                        continue;
                    }
                    props[index] = item.get(key);
                    index++;
                }
                props[size] = buffer;
                result.add(props);
            }
        }finally {
            dataInputStream.close();
            in.close();
        }
        return result;
    }*/

    @Override
    public List<Object[]> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        List<Object[]> result = new ArrayList<>();
        try {
            HttpEntity entity = response.getEntity();
            if (HttpStatus.SC_OK != response.getStatusLine().getStatusCode()) {
                String message = EntityUtils.toString(entity);
                if (message.contains("key not found:")) {
                    return result;
                } else {
                    throw new ClientProtocolException(message);
                }
            }
            byte[] allData = EntityUtils.toByteArray(entity);
            ByteBuffer byteBuffer = ByteBuffer.wrap(allData);
            int len = byteBuffer.getInt();
            byte[] buff = getBytesByLength(byteBuffer, len);
            byte[] propByte = Snappy.uncompress(buff);
            JSONArray array = (JSONArray) JSON.parse(propByte, 0, propByte.length, new UTF8Decoder());
            int propSize = fields.size();
            int offsetLen = byteBuffer.getInt();

            byte[] offsetByte = this.getBytesByLength(byteBuffer, offsetLen);
            int featureNum = offsetLen / 4;
            ByteBuffer offsetBuffer = ByteBuffer.wrap(offsetByte);
            int feaLen = 0;
            ByteArrayInputStream bin = null;
            JSONObject item = null;
            for (int i = 0; i < featureNum; i++) {
                feaLen = offsetBuffer.getInt();
                byte[] fea = this.getBytesByLength(byteBuffer, feaLen);
                //bin = new ByteArrayInputStream(fea);
                GeoBuffer buffer = null;
                try {
                    buffer = WkbDecoder.DECODER.toGeoBuffer(fea);
                } catch (Exception e) {
                    throw new ClientProtocolException(e);
                }
                Object[] props = new Object[propSize + 1];
                item = array.getJSONObject(i);
                props[0] = item.get(idField);
                int size = item.size();
                int index = 1;
                String key = null;
                Iterator<String> keyInterator = fields.iterator();
                while (keyInterator.hasNext()) {
                    key = keyInterator.next();
                    if (key.equals(idField)) {
                        continue;
                    }
                    props[index] = item.get(key);
                    index++;
                }
                props[size] = buffer;
                result.add(props);
            }
        } finally {

        }
        return result;
    }

    private byte[] getBytesByLength(ByteBuffer byteBuffer, int len) throws IOException {
        byte[] buff = new byte[len];
        byteBuffer.get(buff, 0, len);
        return buff;
    }

    private byte[] getBytesByLength(DataInputStream dataInputStream, int len) throws IOException {
        int splitLen = len > 1024 ? 1024 : len;

        byte[] tmpbuffer = new byte[splitLen];
        int surplus = len;
        int readLen = 0;
        byte[] buff = new byte[len];
        ByteBuffer byteBuffer = ByteBuffer.wrap(buff);
        while((readLen = dataInputStream.read(tmpbuffer,0, splitLen))>= 0 && surplus > 0){
            byteBuffer.put(tmpbuffer, 0, readLen);
            surplus-= readLen;
            if (surplus < splitLen){
                splitLen = surplus;
            }

        }
        return buff;
    }
}
