/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.spark;

import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.spark.SparkDataSource;
import com.northpool.resources.datatable.IField;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IMapDAO;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.datatable.db.AbstractDBDAO;
import com.northpool.resources.datatable.spark.SparkTable;
import com.northpool.resources.dialect.spark.SparkSQLDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.resources.sql.QueryFilterToSQL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SparkPersistDaoImpl<PK>
extends AbstractDBDAO<PK, Map<String, Object>>
implements IMapDAO<PK> {
    protected SparkTable dbTable;
    SparkDataSource dbDataSource;

    public SparkPersistDaoImpl(SparkDataSource dbDataSource, SparkTable table) {
        super((IDataSource)dbDataSource, (ITable)table, null);
        this.dbDataSource = dbDataSource;
        this.dbTable = table;
    }

    protected void checkWriteable() {
        if (this.dbTable.getIsView().booleanValue()) {
            throw new RuntimeException(this.dbTable.mark() + "\u4e3a\u8bd5\u56fe,\u4e0d\u80fd\u6267\u884c\u5199\u64cd\u4f5c");
        }
    }

    public void remove(QueryFilter filter) {
    }

    public List<Object[]> queryArray(QueryFilter filter, Integer fetchSize) {
        List<String> filedNames = filter.getOutputFieldNames();
        filedNames = filedNames.stream().map(name -> ((IField)this.dbTable.getFieldsMap().get(name)).getOriginFieldName()).collect(Collectors.toList());
        filedNames.remove("SHAPE");
        String sqlFilter = null;
        QueryFilterToSQL queryFilterToSQL = new QueryFilterToSQL((ITable)this.dbTable, filter, (ISQLDialect)SparkSQLDialect.INSTANCE, this.dbTable.fieldsTypeMap(), this.dbTable.fieldDecoder(), false);
        QueryFilterToSQL.WherePartSQL wherePart = queryFilterToSQL.toWherePartSQL();
        sqlFilter = wherePart.getWherePart();
        sqlFilter = sqlFilter.indexOf("and") != -1 ? sqlFilter.substring(sqlFilter.indexOf("and") + 4) : "";
        if (filter.getLimit() != null && filter.getLimit() == 1) {
            sqlFilter = sqlFilter + " limit " + filter.getLimit();
        }
        List paras = wherePart.getValues();
        String wkt = null;
        if (paras.size() >= 2) {
            wkt = paras.get(0).toString();
            paras = paras.subList(2, paras.size());
        }
        Object[] parasArr = paras.toArray();
        sqlFilter = sqlFilter.replace("?", "'%s'");
        sqlFilter = sqlFilter.replace("\"", "");
        sqlFilter = String.format(sqlFilter, parasArr);
        Integer srid = filter.getSRID();
        List<Object[]> list = null;
        try {
            list = this.dbDataSource.query(this.dbTable, sqlFilter, srid, wkt, filedNames, this.dbTable.getIdField());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    public IScroll<Map<String, Object>> scroll(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        return null;
    }

    public IScroll<Map<String, Object>> scroll(QueryFilter queryFilter) throws DataAccessException {
        return null;
    }

    public IScroll<Object[]> scrollArray(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        return null;
    }

    public IScroll<Object> scrollId(QueryFilter filter, Integer fetchSize) throws DataAccessException {
        return null;
    }

    public void insertManyDataMap(List<Map<String, ?>> list, Integer batchSize) throws DataAccessException {
    }

    public List<Map<String, Object>> query(QueryFilter filter, Integer fetchSize) {
        List<String> filedNames = filter.getOutputFieldNames();
        if (filedNames.isEmpty()) {
            filedNames = Arrays.asList(this.dbTable.getFields());
        }
        boolean containsShape = filedNames.contains("shape");
        filedNames = filedNames.stream().map(name -> ((IField)this.dbTable.getFieldsMap().get(name)).getOriginFieldName()).collect(Collectors.toList());
        if (containsShape) {
            filedNames.remove("SHAPE");
        }
        String sqlFilter = null;
        QueryFilterToSQL queryFilterToSQL = new QueryFilterToSQL((ITable)this.dbTable, filter, (ISQLDialect)SparkSQLDialect.INSTANCE, this.dbTable.fieldsTypeMap(), this.dbTable.fieldDecoder(), false);
        QueryFilterToSQL.WherePartSQL wherePart = queryFilterToSQL.toWherePartSQL();
        sqlFilter = wherePart.getWherePart();
        sqlFilter = sqlFilter.indexOf("and") != -1 ? sqlFilter.substring(sqlFilter.indexOf("and") + 4) : "";
        if (filter.getLimit() != null && filter.getLimit() == 1) {
            sqlFilter = sqlFilter + " limit " + filter.getLimit();
        }
        List paras = wherePart.getValues();
        String wkt = null;
        if (paras.size() >= 2) {
            wkt = paras.get(0).toString();
            paras = paras.subList(2, paras.size());
        }
        Object[] parasArr = paras.toArray();
        sqlFilter = sqlFilter.replace("?", "'%s'");
        sqlFilter = sqlFilter.replace("\"", "");
        sqlFilter = String.format(sqlFilter, parasArr);
        Integer srid = filter.getSRID();
        List<Map<String, Object>> list = null;
        try {
            list = this.dbDataSource.queryForMap(this.dbTable, sqlFilter, srid, wkt, filedNames);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!containsShape) {
            list.stream().forEach(item -> item.remove("shape"));
        }
        return list;
    }

    public Long count(QueryFilter queryFilter) throws DataAccessException {
        return null;
    }

    public List<Map<String, Object>> query(QueryFilter queryFilter) throws DataAccessException {
        return null;
    }

    public void insert(Map<String, Object> stringMap) throws DataAccessException {
    }

    public void saveOrUpdate(Map<String, Object> stringMap) throws DataAccessException {
    }

    public void update(Map<String, Object> stringMap) throws DataAccessException {
    }

    public void removeAll() throws DataAccessException {
    }

    public void insertMany(List<Map<String, Object>> list) throws DataAccessException {
    }

    public void insertMany(List<Map<String, Object>> list, Integer batchSize) throws DataAccessException {
    }

    public void updateMany(Map<String, Object> m, QueryFilter queryFilter) throws DataAccessException {
    }

    public void insertMany(List<Object[]> list, String[] fields, Integer batchSize) throws DataAccessException {
    }
}

