package com.northpool.resources.utils.spark;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.UTF8Decoder;
import com.northpool.resources.datatable.IField;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.wkb.WkbDecoder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.xerial.snappy.Snappy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.*;

public class SparkMapResponseHandler implements ResponseHandler<List<Map<String,Object>>> {

    private final Map<String, IField> fieldsInTableMap;

    public SparkMapResponseHandler(Map<String, IField> fieldsInTableMap){
        this.fieldsInTableMap = fieldsInTableMap;

    }

    @Override
    public List<Map<String,Object>> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        List<Map<String,Object>> result = new ArrayList<>();
        try {
            HttpEntity entity = response.getEntity();
            if (HttpStatus.SC_OK != response.getStatusLine().getStatusCode()) {
                String message = EntityUtils.toString(entity);
                if (message.contains("key not found:")) {
                    return result;
                } else {
                    throw new ClientProtocolException(message);
                }
            }
            byte[] allData = EntityUtils.toByteArray(entity);
            ByteBuffer byteBuffer = ByteBuffer.wrap(allData);
            int len = byteBuffer.getInt();
            byte[] buff = getBytesByLength(byteBuffer, len);
            byte[] propByte = Snappy.uncompress(buff);
            JSONArray array = (JSONArray) JSON.parse(propByte, 0, propByte.length, new UTF8Decoder());
            int offsetLen = byteBuffer.getInt();
            byte[] offsetByte = this.getBytesByLength(byteBuffer, offsetLen);
            int featureNum = offsetLen / 4;
            ByteBuffer offsetBuffer = ByteBuffer.wrap(offsetByte);
            int feaLen = 0;
            ByteArrayInputStream bin = null;
            JSONObject item = null;
            Map<String, Object> feaMap = null;
            String key = null;
            for (int i = 0; i < featureNum; i++) {
                item = array.getJSONObject(i);
                feaLen = offsetBuffer.getInt();
                byte[] fea = this.getBytesByLength(byteBuffer, feaLen);
                //bin = new ByteArrayInputStream(fea);
                GeoBuffer buffer = null;
                try {
                    buffer = WkbDecoder.DECODER.toGeoBuffer(fea);
                } catch (Exception e) {
                    throw new ClientProtocolException(e);
                }
                Iterator<String> iterator = item.keySet().iterator();
                feaMap = new HashMap<>(item.size());
                while (iterator.hasNext()){
                    key = iterator.next();
                    feaMap.put(fieldsInTableMap.get(key).getFieldName(), item.get(key));
                }
                feaMap.put("shape", buffer);
                result.add(feaMap);
            }
        } finally {

        }
        return result;
    }

    private byte[] getBytesByLength(ByteBuffer byteBuffer, int len) throws IOException {
        byte[] buff = new byte[len];
        byteBuffer.get(buff, 0, len);
        return buff;
    }

}
