/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.dialect.spark;

import com.northpool.resources.Constants;
import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.resources.dialect.ICreateTableFieldRefDialect;
import com.northpool.resources.dialect.IResourcesDataInput;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.dialect.function.Function;
import com.northpool.resources.dialect.function.sql.SQLSpatialRelateFunction;
import com.northpool.resources.dialect.function.sql.SpatialFilterExpression;
import com.northpool.resources.dialect.sql.AbstractSQLDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.type.Type;
import com.northpool.type.TypeBytes;
import com.northpool.type.TypePostGisGeometry;
import com.northpool.type.Types;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import org.locationtech.jts.geom.Geometry;

public class SparkSQLDialect
extends AbstractSQLDialect
implements ISQLDialect {
    public static SparkSQLDialect INSTANCE = new SparkSQLDialect();

    public SparkSQLDialect() {
        this.name = Constants.DATA_SOURCE_TYPE.postgreSQL.name();
    }

    public Constants.DATA_SOURCE_TYPE getDataSourceType() {
        return Constants.DATA_SOURCE_TYPE.postgreSQL;
    }

    public boolean isColumnSerial(ColumnBean columnBean, String columnTypeName) {
        return false;
    }

    public <INPUT, INDEX_OR_LABEL> IResourcesDataInput<INPUT, INDEX_OR_LABEL> getResourcesDataDataInput() {
        return null;
    }

    public <OUTPUT, INDEX_OR_LABEL> IResourcesDataOutput<OUTPUT, INDEX_OR_LABEL> getResourcesDataOutput() {
        return null;
    }

    public <TABLE_BUILD, FIELD> ICreateTableFieldRefDialect<TABLE_BUILD, FIELD> getCreateTableFieldRefDialect() {
        return null;
    }

    protected void registerTypes() {
        this.registerType((Type)Types.INTEGER, new String[]{"serial", "int", "int2", "int4", "integer"});
        this.registerClassType((Type)Types.INTEGER, new Class[]{Integer.class, Short.class});
        this.registerType((Type)TypePostGisGeometry.INSTANCE, new String[]{"geometry"});
        this.registerClassType((Type)TypePostGisGeometry.INSTANCE, new Class[]{Geometry.class, GeoBuffer.class});
        this.registerType((Type)Types.STRING, new String[]{"varchar", "bpchar", "character varying", "text", "json", "jsonb", "path"});
        this.registerClassType((Type)Types.STRING, new Class[]{String.class});
        this.registerType((Type)Types.DOUBLE, new String[]{"float", "float4", "float8", "double"});
        this.registerClassType((Type)Types.DOUBLE, new Class[]{Double.class, Float.class});
        this.registerType((Type)Types.BIGDECIMAL, new String[]{"numeric", "number"});
        this.registerClassType((Type)Types.BIGDECIMAL, new Class[]{BigDecimal.class, BigInteger.class});
        this.registerType((Type)Types.TIME_STAMP, new String[]{"timestamp", "date"});
        this.registerClassType((Type)Types.TIME_STAMP, new Class[]{Date.class});
        this.registerType((Type)Types.BOOLEAN, new String[]{"boolean", "bool"});
        this.registerClassType((Type)Types.BOOLEAN, new Class[]{Boolean.class});
        this.registerType((Type)Types.LONG, new String[]{"long", "int8"});
        this.registerClassType((Type)Types.LONG, new Class[]{Long.class});
        this.registerType((Type)TypeBytes.INSTANCE, new String[]{"bytea", "byte[]"});
        this.registerClassType((Type)TypeBytes.INSTANCE, new Class[]{byte[].class});
    }

    public String getSelfDesc() {
        return "PostgreSQL\u65b9\u8a00";
    }

    protected void registerFunctions() {
        Type[] typeIn = new Type[]{TypePostGisGeometry.INSTANCE, TypePostGisGeometry.INSTANCE};
        this.registerFunction("intersects", (Function)new SQLSpatialRelateFunction("st_intersects", (Type)Types.BOOLEAN, typeIn));
        this.registerFunction("equals", (Function)new SQLSpatialRelateFunction("st_equals", (Type)Types.BOOLEAN, typeIn));
        this.registerFunction("contains", (Function)new SQLSpatialRelateFunction("st_contains", (Type)Types.BOOLEAN, typeIn));
        this.registerFunction("crosses", (Function)new SQLSpatialRelateFunction("st_crosses", (Type)Types.BOOLEAN, typeIn));
        this.registerFunction("disjoint", (Function)new SQLSpatialRelateFunction("st_disjoint", (Type)Types.BOOLEAN, typeIn));
        this.registerFunction("touches", (Function)new SQLSpatialRelateFunction("st_touches", (Type)Types.BOOLEAN, typeIn));
        this.registerFunction("within", (Function)new SQLSpatialRelateFunction("st_within", (Type)Types.BOOLEAN, typeIn));
        this.registerFunction("overlaps", (Function)new SQLSpatialRelateFunction("st_overlaps", (Type)Types.BOOLEAN, typeIn));
        this.registerFunction("mbr_intersects", (Function)new SpatialFilterExpression((Type)Types.BOOLEAN, typeIn));
    }

    public String getJDBCDriver() {
        return "org.postgresql.Driver";
    }

    public String createConnectUrl(String url) {
        return "jdbc:postgresql://" + url;
    }

    public Boolean markForTableNameAndColumnName() {
        return true;
    }

    public void setFetchSize(Connection connection, PreparedStatement preparedStatement, Integer fetchSize) throws SQLException {
        connection.setAutoCommit(false);
        preparedStatement.setFetchSize(fetchSize);
        preparedStatement.setFetchDirection(1000);
    }

    protected boolean defaultValueIsSequence(String columnTypeName, String defaultValue) {
        return false;
    }

    protected boolean defaultValueIsFuntion(String columnTypeName, String defaultValue) {
        return false;
    }

    protected boolean defaultValueIsNowDate(String columnTypeName, String defaultValue) {
        return false;
    }

    public String getDefaultSchema() {
        return "public";
    }

    public Boolean isFieldSerial(String columnTypeName) {
        return null;
    }

    public String createSequenceName(String schema, String tableName, String fieldName) {
        return null;
    }

    public String hasSequenceSql(String sequenceName) {
        return null;
    }

    public String getCreateSequenceSQL(String sequenceName) {
        return null;
    }
}

