package com.northpool.resources.datatable.spark.operate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.spark.SparkDataSource;
import com.northpool.resources.datatable.AbstractTable;
import com.northpool.resources.datatable.FieldEncoder;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.operate.*;
import com.northpool.resources.datatable.spark.SparkTable;
import com.northpool.resources.datatablebuilder.spark.column.SparkColumn;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.spark.SparkSQLDialect;
import com.northpool.resources.utils.spark.HttpUtils;
import com.northpool.spatial.Constants;
import com.northpool.spatial.geofeature.GeoBuffer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.client.methods.HttpGet;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;


@ATableOperator(name = "spark",type = DATA_SOURCE_TYPE.spark)
public class SparkTableBuilder extends AbstractTableOperator implements ITableOperator {

    //获取字段列表接口
    protected final String archieveFieldsUrl = "/data/cat/fieldnames?layername=%s";

    //获取主键字段接口
    protected final String archievePkFieldUrl = "/data/cat/oids?layername=%s";

    String[] columnArray;

    /* (non-Javadoc)
     * @see com.northpool.resources.datatablebuilder.ITableBuilder#toBean()
     */
    public TableSchemaBean toBean() {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatablebuilder.ITableBuilder#init(java.lang.String, com.northpool.resources.datasource.IDataSource, java.util.Map)
     */
    public void init(String tableName, IDataSource dataSource, Map<String, ?> config) throws Exception {
        this.tableName = tableName;

        this.dataSource = dataSource;
        this.columnArray = null;
        this.columnMap = null;
        this.dialect = SparkSQLDialect.INSTANCE;
        this.buildColumns();
       /* if(this.hasSpatialColumn()){
            this.buildSpatialColumnInfo();
        }*/
    }

    @Override
    protected SparkTable _getTable() {
        return new SparkTable();
    }

    private void buildColumns(){
        String url = ((SparkDataSource)this.dataSource).getUrl() + String.format(archieveFieldsUrl, this.tableName);
        HttpGet httpGet = new HttpGet(url);
        String fieldsStr = HttpUtils.sendHttpGet(httpGet);
        JSONObject fieldsObj = JSON.parseObject(fieldsStr);
        JSONArray fieldsArr = fieldsObj.getJSONArray("message");
        int size = fieldsArr.size();
        String pkUrl = ((SparkDataSource)this.dataSource).getUrl() + String.format(archievePkFieldUrl, this.tableName);
        HttpGet pkGet = new HttpGet(pkUrl);

        String pkFieldStr = HttpUtils.sendHttpGet(pkGet);
        JSONObject pkFieldObj = JSON.parseObject(pkFieldStr);
        String pkField = (String) pkFieldObj.getJSONArray("message").get(0);

        this.columnMap = new LinkedHashMap<>(size + 1);
        this.columnArray = new String[size + 1];
        IColumn pkColumn = this.createColumn(pkField, null, null, "string", null, null, null);
        pkColumn.setPK();
        this.columnMap.put(pkField, pkColumn);
        this.columnArray[0] = pkField;
        int index = 1;
        Iterator fieldIterator = fieldsArr.iterator();
        while (fieldIterator.hasNext()){
            String field = (String) fieldIterator.next();
            if (field.equals(pkField)){
                continue;
            }
            IColumn column = this.createColumn(field, null, null, "string", null, null, null);
            this.columnMap.put(field, column);
            this.columnArray[index] = field;
            index ++;
        }

        IColumn shape = this.createColumn("SHAPE", null, null, "geometry", null, null, null);
        shape.setSRID(4490);
        this.columnMap.put("SHAPE", shape);
        this.columnArray[size] = "SHAPE";
    }

    @Override
    @SuppressWarnings("unchecked")
    public ITable getTable(String[] selectFields){
        AbstractTable table = this._getTable();
        table.init(this, new FieldEncoder(){

            @Override
            public String encode(String fieldInDB) {
                // TODO Auto-generated method stub

                if(ArrayUtils.indexOf(selectFields, fieldInDB) == -1){
                    return null;
                }
                return ITableOperator.DEFAULT_ENCODER.encode(fieldInDB);
            }

            @Override
            public String getFieldEncoderName() {
                // TODO Auto-generated method stub
                return "tmp";
            }

        },selectFields);
        return table;
    }

    @Override
    protected CompletableFuture<Object> createSpatialIndex(String colname) {
        return null;
    }

    @Override
    protected CompletableFuture<Object> _createIndex(Boolean unique, String... colnames) {
        return null;
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.Markable#mark()
     */
    public String mark() {
        // TODO Auto-generated method stub
        return this.dataSource  + "@" + this.tableName;
    }


    /* (non-Javadoc)
     * @see com.northpool.resources.datatablebuilder.AbstractTableBuilder#getSpatialInfo(java.lang.String)
     */
    @Override
    protected Object[] getSpatialInfo(String colunmName) throws SQLException {
        // TODO Auto-generated method stub
        return new Object[]{4490, Constants.GEO_TYPE.MULTIPOLYGON};
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatablebuilder.AbstractTableBuilder#getGeoBufferInfoByData(java.lang.String)
     */
    @Override
    protected GeoBuffer getGeoBufferInfoByData(String colunmName) throws SQLException {
        // TODO Auto-generated method stub
        return null;
    }

    protected IColumn createColumn(String columnName, Integer columnSize, Integer digits,
                                   String columnTypeName, Boolean nullable, Boolean withDefault, String remarks) {
        SparkColumn column = new SparkColumn( columnName,  columnSize,  digits,
                columnTypeName,  nullable,  null,  remarks,(IDialect)this.dialect);
        return column;
    }

    @Override
    public CompletableFuture<Object> createPK(String colname) {
        return null;
    }

    @Override
    public CompletableFuture<Object> dropIndex(String indexName) {
        return null;
    }

    @Override
    public CompletableFuture<Object> dropPK() {
        return null;
    }

    @Override
    public String getPKColumn(){
        Optional<IColumn> hasPk = this.columnMap.values().stream().filter(c -> c.isPK()).findFirst();
        if (hasPk.isPresent()){
            return hasPk.get().getColumnName();
        }
        return null;
    }


}
