package com.northpool.resources.utils.spark;

import org.apache.http.HttpEntity;
import org.apache.http.HttpStatus;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;

public class HttpUtils {

    static ThreadLocal<CloseableHttpClient> threadLocal = new ThreadLocal<>();

    static CloseableHttpClient httpClient = null;

    static PoolingHttpClientConnectionManager pool = null;
    static {
        Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.<ConnectionSocketFactory> create()
                .register("http", PlainConnectionSocketFactory.getSocketFactory())
                .register("https", new SSLConnectionSocketFactory(createIgnoreVerifySSL())).build();
        pool = new PoolingHttpClientConnectionManager(
                socketFactoryRegistry);
        pool.setMaxTotal(1000);

        pool.setDefaultMaxPerRoute(1000);

        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000)
                .setConnectionRequestTimeout(120000).build();

        httpClient = HttpClients.custom()
                // 设置连接池管理
                .setConnectionManager(pool)
                // 设置请求配置
                .setDefaultRequestConfig(requestConfig)
                // 设置重试次数
                .setRetryHandler(new DefaultHttpRequestRetryHandler(2, true))

                .build();
        new Thread(()->{
            while (true){
                pool.closeIdleConnections(20000, TimeUnit.MILLISECONDS);
                pool.closeExpiredConnections();
                try {
                    Thread.sleep(5000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public static CloseableHttpClient getHttpClient(){
        return httpClient;
/*        if (threadLocal.get() != null){
            return threadLocal.get();
        }
        Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.<ConnectionSocketFactory> create()
                .register("http", PlainConnectionSocketFactory.getSocketFactory())
                .register("https", new SSLConnectionSocketFactory(createIgnoreVerifySSL())).build();
        PoolingHttpClientConnectionManager pool = new PoolingHttpClientConnectionManager(
                socketFactoryRegistry);
        pool.setMaxTotal(1000);

        pool.setDefaultMaxPerRoute(1000);

        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000)
                .setConnectionRequestTimeout(120000).build();

        CloseableHttpClient httpClient = HttpClients.custom()
                // 设置连接池管理
                .setConnectionManager(pool)
                // 设置请求配置
                .setDefaultRequestConfig(requestConfig)
                // 设置重试次数
                .setRetryHandler(new DefaultHttpRequestRetryHandler(2, true))

                .build();
        threadLocal.set(httpClient);*/

       /* RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000)
                .setConnectionRequestTimeout(120000).build();

        CloseableHttpClient httpClient = HttpClients.custom()
                // 设置请求配置
                .setDefaultRequestConfig(requestConfig)
                .setRetryHandler(new DefaultHttpRequestRetryHandler(2, true))
                .build();
        return httpClient;*/
    }


    public static final String CHARSET_UTF_8 = "utf-8";


    public static HttpPost buildPostBodyRequest(String url, String body) throws UnsupportedEncodingException {
        HttpPost request = new HttpPost(url);
        request.setEntity(new StringEntity(body, Charset.forName("utf-8")));
        request.addHeader("Connection", "close");//禁用场链接
        return request;
    }

    public static SSLContext createIgnoreVerifySSL() {
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSLv3");

            // 实现一个X509TrustManager接口，用于绕过验证，不用修改里面的方法
            X509TrustManager trustManager = new X509TrustManager() {
                @Override
                public void checkClientTrusted(java.security.cert.X509Certificate[] paramArrayOfX509Certificate,
                                               String paramString) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(java.security.cert.X509Certificate[] paramArrayOfX509Certificate,
                                               String paramString) throws CertificateException {
                }

                @Override
                public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };

            sc.init(null, new TrustManager[] { trustManager }, null);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return sc;
    }

    public static CloseableHttpResponse sendHttpPost(HttpPost httpPost) throws IOException {
        CloseableHttpClient closeableHttpClient = getHttpClient();
        CloseableHttpResponse response = null;
        try {
            response = closeableHttpClient.execute(httpPost);
        }catch (Exception e){
            closeableHttpClient.close();
            threadLocal.remove();
            throw e;
        }
        return response;
    }

    /**
     * 发送Get请求
     *
     * @param httpGet
     * @return
     */
    public static String sendHttpGet(HttpGet httpGet) {

        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        // 响应内容
        String responseContent = null;
        try {
            // 创建默认的httpClient实例.
            httpClient = HttpClients.createDefault();
            // 执行请求
            response = httpClient.execute(httpGet);
            // 得到响应实例
            HttpEntity entity = response.getEntity();

            if (response.getStatusLine().getStatusCode() >= 300) {
                responseContent = EntityUtils.toString(entity, CHARSET_UTF_8);
                EntityUtils.consume(entity);
                throw new Exception(
                        "HTTP Request is not success, Response code is " + response.getStatusLine().getStatusCode() + ", error:" + responseContent);
            }


            if (HttpStatus.SC_OK == response.getStatusLine().getStatusCode()) {
                responseContent = EntityUtils.toString(entity, CHARSET_UTF_8);
                EntityUtils.consume(entity);
            }

        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                // 释放资源
                if (response != null) {
                    response.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseContent;
    }


}
