/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.spark.operate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.northpool.resources.Constants;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.spark.SparkDataSource;
import com.northpool.resources.datatable.FieldEncoder;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.operate.ATableOperator;
import com.northpool.resources.datatable.operate.AbstractTableOperator;
import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.datatable.operate.ITableOperator;
import com.northpool.resources.datatable.operate.TableSchemaBean;
import com.northpool.resources.datatable.spark.SparkTable;
import com.northpool.resources.datatablebuilder.spark.column.SparkColumn;
import com.northpool.resources.dialect.spark.SparkSQLDialect;
import com.northpool.resources.utils.spark.HttpUtils;
import com.northpool.spatial.Constants;
import com.northpool.spatial.geofeature.GeoBuffer;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.client.methods.HttpGet;

@ATableOperator(name="spark", type=Constants.DATA_SOURCE_TYPE.spark)
public class SparkTableBuilder
extends AbstractTableOperator
implements ITableOperator {
    protected final String archieveFieldsUrl = "/data/cat/fieldnames?layername=%s";
    protected final String archievePkFieldUrl = "/data/cat/oids?layername=%s";
    String[] columnArray;

    public TableSchemaBean toBean() {
        return null;
    }

    public void init(String tableName, IDataSource dataSource, Map<String, ?> config) throws Exception {
        this.tableName = tableName;
        this.dataSource = dataSource;
        this.columnArray = null;
        this.columnMap = null;
        this.dialect = SparkSQLDialect.INSTANCE;
        this.buildColumns();
    }

    protected SparkTable _getTable() {
        return new SparkTable();
    }

    private void buildColumns() {
        Map<String, Object> buildColumns = this.getBuildColumns();
        this.columnMap = (LinkedHashMap)buildColumns.get("columnMap");
        this.columnArray = (String[])buildColumns.get("columnArray");
    }

    public ITable getTable(final String[] selectFields) {
        SparkTable table = this._getTable();
        table.init(this, new FieldEncoder(){

            public String encode(String fieldInDB) {
                if (ArrayUtils.indexOf((Object[])selectFields, (Object)fieldInDB) == -1) {
                    return null;
                }
                return ITableOperator.DEFAULT_ENCODER.encode(fieldInDB);
            }

            public String getFieldEncoderName() {
                return "tmp";
            }
        }, selectFields);
        return table;
    }

    protected CompletableFuture<Object> createSpatialIndex(String colname) {
        return null;
    }

    protected CompletableFuture<Object> _createIndex(Boolean unique, String ... colnames) {
        return null;
    }

    public String mark() {
        return this.dataSource + "@" + this.tableName;
    }

    protected Object[] getSpatialInfo(String colunmName) throws SQLException {
        return new Object[]{4490, Constants.GEO_TYPE.MULTIPOLYGON};
    }

    protected GeoBuffer getGeoBufferInfoByData(String colunmName) throws SQLException {
        return null;
    }

    protected IColumn createColumn(String columnName, Integer columnSize, Integer digits, String columnTypeName, Boolean nullable, Boolean withDefault, String remarks) {
        SparkColumn column = new SparkColumn(columnName, columnSize, digits, columnTypeName, nullable, null, remarks, this.dialect);
        return column;
    }

    public CompletableFuture<Object> createPK(String colname) {
        return null;
    }

    public CompletableFuture<Object> dropIndex(String indexName) {
        return null;
    }

    public CompletableFuture<Object> dropPK() {
        return null;
    }

    public String getPKColumn() {
        Optional<IColumn> hasPk = this.columnMap.values().stream().filter(c -> c.isPK()).findFirst();
        if (hasPk.isPresent()) {
            return hasPk.get().getColumnName();
        }
        return null;
    }

    public LinkedHashMap<String, IColumn> getTableColumns() throws Exception {
        return (LinkedHashMap)this.getBuildColumns().get("columnMap");
    }

    protected Map<String, Object> getBuildColumns() {
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        String url = ((SparkDataSource)this.dataSource).getUrl() + String.format("/data/cat/fieldnames?layername=%s", this.tableName);
        HttpGet httpGet = new HttpGet(url);
        String fieldsStr = HttpUtils.sendHttpGet(httpGet);
        JSONObject fieldsObj = JSON.parseObject((String)fieldsStr);
        JSONArray fieldsArr = fieldsObj.getJSONArray("message");
        int size = fieldsArr.size();
        String pkUrl = ((SparkDataSource)this.dataSource).getUrl() + String.format("/data/cat/oids?layername=%s", this.tableName);
        HttpGet pkGet = new HttpGet(pkUrl);
        String pkFieldStr = HttpUtils.sendHttpGet(pkGet);
        JSONObject pkFieldObj = JSON.parseObject((String)pkFieldStr);
        String pkField = (String)pkFieldObj.getJSONArray("message").get(0);
        LinkedHashMap<String, IColumn> columnMap = new LinkedHashMap<String, IColumn>(size + 1);
        String[] columnArray = new String[size + 1];
        IColumn pkColumn = this.createColumn(pkField, null, null, "string", null, null, null);
        pkColumn.setPK();
        columnMap.put(pkField, pkColumn);
        columnArray[0] = pkField;
        int index = 1;
        for (String field : fieldsArr) {
            if (field.equals(pkField)) continue;
            IColumn column = this.createColumn(field, null, null, "string", null, null, null);
            columnMap.put(field, column);
            columnArray[index] = field;
            ++index;
        }
        IColumn shape = this.createColumn("SHAPE", null, null, "geometry", null, null, null);
        shape.setSRID(Integer.valueOf(4490));
        columnMap.put("SHAPE", shape);
        columnArray[size] = "SHAPE";
        mapResult.put("columnArray", columnArray);
        mapResult.put("columnMap", columnMap);
        return mapResult;
    }
}

