package com.northpool.service;

import com.northpool.AppUtil;
import com.northpool.commons.classloader.MemoryClassLoader;
import com.northpool.service.client.Client;
import com.northpool.service.netty.websocket.WebSocketServer;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClientMain {

    MemoryClassLoader loader;

    Object client;

    Class clientClass;

    public ClientMain(String path, Object[] info) throws IOException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        String curPath = path;
        //CustomClassLoader customClassLoader = CustomClassLoader.getCustomClassLoader(Thread.currentThread().getContextClassLoader().getParent());
       // this.loader = new MemoryClassLoader(customClassLoader);
        this.loader = new MemoryClassLoader();
        //customClassLoader.setLoader(this.loader);
        Thread.currentThread().setContextClassLoader(loader);

        for(int i = 0; i < info.length / 2 ; i ++){
            loader.loadJar((String)info[i * 2], (byte[])info[(i * 2) + 1]);
        }

        System.setProperty("APP_HOME", curPath);

    }

    public Object init(String mongoUri, String zkAddress, String mapserverUrl, Integer tcpPort) throws Exception {
        Thread.currentThread().setContextClassLoader(loader);
        this.clientClass = this.loader.loadClass("com.northpool.service.client.Client");
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("conf/app-context.xml");
        AppUtil.appContext = ctx;
        Constructor constructor = clientClass.getDeclaredConstructor(String.class, String.class, String.class);
        this.client = constructor.newInstance(mongoUri, zkAddress, mapserverUrl);
        new WebSocketServer((Client) this.client).bind(tcpPort);
        return this.client;
    }

    public Object getTextureManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getTextureManager");
        return method.invoke(this.client);
    }

    public Object getVectorServiceManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException{
        Method method = this.clientClass.getMethod("getVectorServiceManager");
        return method.invoke(this.client);
    }


    public Object getDataSourcesManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException{
        Method method = this.clientClass.getMethod("getDataSourcesManager");
        return method.invoke(this.client);
    }

    public Object getDataServiceManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException{
        Method method = this.clientClass.getMethod("getDataServiceManager");
        return method.invoke(this.client);
    }

    public Object getStyleManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getStyleManager");
        return method.invoke(this.client);
    }

    public Object getFontManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getFontManager");
        return method.invoke(this.client);
    }

    public Object getTileDataCellManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getTileDataCellManager");
        return method.invoke(this.client);
    }

    public static void main(String[] args) {

    }


}
