package com.northpool.service.config.style.layer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;

import java.lang.reflect.Type;
import java.util.List;

//fastjson
@JSONType(deserializer = AbstractLayer.AbstractLayerDeserializer.class)
public abstract class AbstractLayer {

    private Integer status;
    private String type;
    private Boolean isleaf;
    private String id;
    private String name;
    private String iconType;

    //    @JSONField(deserializeUsing = ChildrenDeserializer.class)
    private List<AbstractLayer> children;

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean getIsleaf() {
        return isleaf;
    }

    public void setIsleaf(Boolean isleaf) {
        this.isleaf = isleaf;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIconType() {
        return iconType;
    }

    public void setIconType(String iconType) {
        this.iconType = iconType;
    }

    public List<AbstractLayer> getChildren() {
        return children;
    }

    public void setChildren(List<AbstractLayer> children) {
        this.children = children;
    }

    public static class AbstractLayerDeserializer implements ObjectDeserializer {

        @Override
        public AbstractLayer deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
            JSONObject jsonObject = parser.parseObject();
            if ("files".equals(jsonObject.getString("type"))) {
                return JSON.parseObject(jsonObject.toJSONString(), Files.class);// jsonObject.toJavaObject(Files.class);
            } else {
                return JSON.parseObject(jsonObject.toJSONString(), Layer.class);//jsonObject.toJavaObject(Layer.class);
            }
        }

        @Override
        public int getFastMatchToken() {
            return JSONToken.UNDEFINED;
        }
    }

    public static class ChildrenDeserializer implements ObjectDeserializer {

        @Override
        public List<AbstractLayer> deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
            return parser.parseArray(AbstractLayer.class);
        }

        @Override
        public int getFastMatchToken() {
            return JSONToken.UNDEFINED;
        }
    }
}
