package com.northpool.service.config.style.style;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;

import java.lang.reflect.Type;
import java.util.List;

//fastjson
@JSONType(deserializer = AbstractStyle.AbstractStyleDeserializer.class)
public abstract class AbstractStyle {

    private Boolean isVisbile;
    private String iconType;
    private String name;
    private String id;
    private Boolean isleaf;
    private String type;
    private String layer;
    private String parentId;
    private Integer status;
    private List<Pick> pickArr;//精编
    private List<AbstractStyle> children;

    public Boolean getVisbile() {
        return isVisbile;
    }

    public void setVisbile(Boolean visbile) {
        isVisbile = visbile;
    }

    public String getIconType() {
        return iconType;
    }

    public void setIconType(String iconType) {
        this.iconType = iconType;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean getIsleaf() {
        return isleaf;
    }

    public void setIsleaf(Boolean isleaf) {
        this.isleaf = isleaf;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLayer() {
        return layer;
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public List<AbstractStyle> getChildren() {
        return children;
    }

    public void setChildren(List<AbstractStyle> children) {
        this.children = children;
    }

    public List<Pick> getPickArr() {
        return pickArr;
    }

    public void setPickArr(List<Pick> pickArr) {
        this.pickArr = pickArr;
    }

    public static class AbstractStyleDeserializer implements ObjectDeserializer {

        @Override
        public AbstractStyle deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
            JSONObject jsonObject = parser.parseObject();
            if ("group".equals(jsonObject.getString("type")) || "files".equals(jsonObject.getString("type"))) {
                return JSON.parseObject(jsonObject.toJSONString(), Group.class); //jsonObject.toJavaObject(Group.class);
            } else {
                return JSON.parseObject(jsonObject.toJSONString(), Style.class);//jsonObject.toJavaObject(Style.class);
            }
        }

        @Override
        public int getFastMatchToken() {
            return 0;
        }
    }
}
