package com.northpool.service.config.vector_service;

import com.northpool.resources.MongodbFactory;
import com.northpool.resources.command.Constants;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.style.IStyleService;
import com.northpool.service.manager.style.IStyleManager;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

public class CacheInfoShell implements ICacheable {
	
	protected Client client;
	
	protected CacheInfoBean cacheInfo;
	
	public CacheInfoShell(Client client,CacheInfoBean cacheInfo){
		this.client = client;
		this.cacheInfo = cacheInfo;	
	}

	@Override
	public boolean needDataCache() {
		// TODO Auto-generated method stub
		return this.cacheInfo.needDataCache;
	}

	@Override
	public boolean needImgCache() {
		// TODO Auto-generated method stub
		return this.cacheInfo.needImgCache;
	}

	@Override
	public String getImgScript() {
		// TODO Auto-generated method stub
		return this.cacheInfo.imgScript;
	}

	@Override
	public IDataSourceInService getDataCacheSource() {
		// TODO Auto-generated method stub
		String dataCacheSourceId = this.cacheInfo.dataCacheSourceId;
		IDataSourceInService dataSource = this.client.getDataSourcesManager().get(dataCacheSourceId);
		if(dataSource == null){
			throw new RuntimeException(String.format("没有找到数据源ID为%s的数据源", dataCacheSourceId));
		}
		return dataSource;
	}

	@Override
	public IDataSourceInService getImgCacheSource() {
		// TODO Auto-generated method stub
		String imgCacheSourceId = this.cacheInfo.imgCacheSourceId;
		IDataSourceInService dataSource = this.client.getDataSourcesManager().get(imgCacheSourceId);
		if(dataSource == null){
			throw new RuntimeException(String.format("没有找到数据源ID为%s的数据源", imgCacheSourceId));
		}
		return dataSource;
	}

	@Override
	public String getDataScript() {
		// TODO Auto-generated method stub
		return this.cacheInfo.getDataScript();
	}


	@Override
	public CacheInfoBean getCacheInfoBean() {
		return this.cacheInfo;
	}

	@Override
	public void drop(String serverName, String styleId) throws Exception {
		if (StringUtils.isEmpty(styleId)){
			IStyleManager styleManager = client.getStyleManager();
			QueryFilter filter = new QueryFilter();
			filter.addFilter("ownServer", Constants.OPERATION.EQ, serverName);
			List<IStyleService> styleList = styleManager.list(filter);
			for (int i = 0; i < styleList.size(); i++) {
				this.dropStyle(serverName, styleList.get(i).getName());
			}
		}else {
			this.dropStyle(serverName, styleId);
		}
	}

	private void dropStyle(String serverName, String styleId){
		String storageName = serverName + "_" + styleId + "_img_cache";
		IDataSourceInService dataSourceInService = this.client.getDataSourcesManager().get(cacheInfo.getImgCacheSourceId());
		MongodbFactory factory = ((MongodbDataSource)dataSourceInService.getBean()).factory();
		factory.dropCollection(storageName);
	}

}
