package com.northpool.service.config.vector_service.layer;



import com.northpool.service.config.vector_service.storage.StorageInfoBean;

import java.util.Map;

public class LayerBean {

	public static String LINE_LABEL_SUFFIX = "_注记";

	public static Integer MAX_LEVEL = 30;
    /**
     * 主键
     */
    protected String id;
    /**
     * 开始级别
     */
    protected Integer beginLevel;
    /**
     * 结束级别
     */
    protected Integer endLevel;
    /**
     * 记录级别的MAP ,由LEVEL作为KEY
     */
    protected Map<Integer, LayerLevelBean> levelMap;


    protected StorageInfoBean storageInfo;
    
    /**
     * 该图层是否有注记
     */
    protected boolean haveLabel;
    /**
     * 注记信息
     */
    protected Label label;

    protected Boolean labelOnly = false;
    
    protected Boolean cutOutScreen = true;

	public Boolean getCutOutScreen() {
		return cutOutScreen;
	}

	public void setCutOutScreen(Boolean cutOutScreen) {
		this.cutOutScreen = cutOutScreen;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public Integer getBeginLevel() {
		return beginLevel;
	}

	public void setBeginLevel(Integer beginLevel) {
		this.beginLevel = beginLevel;
	}

	public Integer getEndLevel() {
		return endLevel;
	}

	public void setEndLevel(Integer endLevel) {
		this.endLevel = endLevel;
	}

	public Map<Integer, LayerLevelBean> getLevelMap() {
		return levelMap;
	}

	public void setLevelMap(Map<Integer, LayerLevelBean> levelMap) {
		this.levelMap = levelMap;
	}

	public boolean isHaveLabel() {
		return haveLabel;
	}

	public void setHaveLabel(boolean haveLabel) {
		this.haveLabel = haveLabel;
	}

	public Label getLabel() {
		return label;
	}

	public void setLabel(Label label) {
		this.label = label;
	}

	public Boolean getLabelOnly() {
		return labelOnly;
	}
	
	public Boolean isLabelOnly(){
		return labelOnly;
	}

	public void setLabelOnly(Boolean labelOnly) {
		this.labelOnly = labelOnly;
	}

	public StorageInfoBean getStorageInfo() {
		return storageInfo;
	}

	public void setStorageInfo(StorageInfoBean storageInfo) {
		this.storageInfo = storageInfo;
	}
}