package com.northpool.service.manager.data_service;

import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.exception.IdFieldValueEmptyException;
import com.northpool.service.config.data_service.DataServiceInvalidException;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.manager.IClientManager;
import com.northpool.service.manager.abstractclass.ExistsIdException;
import com.northpool.service.manager.abstractclass.NotFoundException;
import com.northpool.service.manager.abstractclass.NotReadyException;
import com.northpool.service.manager.abstractclass.ZKException;

import java.util.List;

public interface IDataServiceManager  extends IClientManager {
	public List<IDataService> list(QueryFilter queryFilter) throws Exception;
	public void register(IDataService t)  throws ExistsIdException,ZKException, IdFieldValueEmptyException, NotReadyException, DataServiceInvalidException;
	public void unRegister(String id) throws ZKException, NotReadyException, NotFoundException;
	public void update(IDataService t) throws Exception;
	public void start(String id) throws Exception;
	public void stop(String id) throws Exception;
	public IScroll<IDataService> scroll(QueryFilter queryFilter);
	public IDataService get(String id);
	public IDataService findOne(QueryFilter queryFilter) throws Exception;
	public String getJSON(String id);

	public void rename(String id, String newName) throws Exception;

}
