package com.northpool.service.manager.data_sources;

import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.exception.IdFieldValueEmptyException;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.manager.IClientManager;
import com.northpool.service.manager.abstractclass.ExistsIdException;
import com.northpool.service.manager.abstractclass.NotFoundException;
import com.northpool.service.manager.abstractclass.NotReadyException;
import com.northpool.service.manager.abstractclass.ZKException;

import java.util.List;


public interface IDataSourcesManager extends IClientManager {
	public void init();
	public List<IDataSourceInService> list(QueryFilter queryFilter) throws Exception;
	public void register(IDataSourceInService t) throws ExistsIdException, ZKException, NotReadyException, IdFieldValueEmptyException;
	public void unRegister(String id) throws ZKException, NotReadyException,NotFoundException;
	public void update(IDataSourceInService t) throws Exception;
	public IScroll<IDataSourceInService> scroll(QueryFilter queryFilter);
	public IDataSourceInService get(String id);
	public IDataSourceInService findOne(QueryFilter queryFilter) throws Exception;
	public boolean checkVersion(String id, String version);
	public String getJSON(String id);
}
