package com.northpool.service.manager.font;

import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.exception.IdFieldValueEmptyException;
import com.northpool.service.config.Constants;
import com.northpool.service.config.font.IFontService;
import com.northpool.service.manager.IClientManager;
import com.northpool.service.manager.abstractclass.ExistsIdException;
import com.northpool.service.manager.abstractclass.NotFoundException;
import com.northpool.service.manager.abstractclass.NotReadyException;
import com.northpool.service.manager.abstractclass.ZKException;
import com.northpool.service.manager.style.StyleInValidException;
import com.northpool.service.manager.texture.TextureInValidException;
import com.northpool.service.mapserver.MapserverAccessException;

import java.util.List;

public interface IFontManager extends IClientManager {
    public void register(IFontService style) throws Exception;

    public void ungister(String id) throws ExistsIdException, IdFieldValueEmptyException, ZKException, NotReadyException, TextureInValidException, MapserverAccessException, StyleInValidException, NotFoundException;

    void ungister(String family, Constants.FONT_STYLE style, Constants.FONT_WEIGHT weight, Constants.FONT_FILE_TYPE filtType) throws ExistsIdException, IdFieldValueEmptyException, ZKException, NotReadyException, TextureInValidException, MapserverAccessException, StyleInValidException, NotFoundException;

    public List<IFontService> list(QueryFilter queryFilter) throws Exception;

    void ungisterByFamily(String family) throws Exception;

    /**
     * 获取字体树
     * @param idPatternStr 用于根据id模糊查询，可以为空
     * @param start
     * @param limit
     * @return
     */
    public String map(String idPatternStr, Integer start, Integer limit) throws Exception;

    IFontService get(String family, Constants.FONT_STYLE style, Constants.FONT_WEIGHT weight, Constants.FONT_FILE_TYPE fileType);

    IFontService get(String id);

    public String getJSON(String id);

    boolean checkVersion(String family, Constants.FONT_STYLE style, Constants.FONT_WEIGHT weight, String version, Constants.FONT_FILE_TYPE fileType);

    boolean checkVersion(String id, String version);

    byte[] getContent(String id);


    /**
     * 获取后端默认字体 family
     * @return
     */
    public String getDefaultFont() throws Exception;


    /**
     * 获取前端生僻字 family
     * @return
     */
    public String getForeendUnCommon() throws Exception;


    /**
     * 获取后端生僻字 family
     * @return
     */
    public String getBackendUnCommon() throws Exception;


    String getFontConfig() throws Exception;
}
