package com.northpool.service.manager.texture;

import com.northpool.resources.exception.IdFieldValueEmptyException;
import com.northpool.service.config.texture.ITextureService;
import com.northpool.service.manager.IClientManager;
import com.northpool.service.manager.abstractclass.ExistsIdException;
import com.northpool.service.manager.abstractclass.NotFoundException;
import com.northpool.service.manager.abstractclass.NotReadyException;
import com.northpool.service.manager.abstractclass.ZKException;

import java.util.List;

public interface ITextureManager  extends IClientManager {
    public void add(List<ITextureService> textures) throws ExistsIdException, IdFieldValueEmptyException, ZKException, NotReadyException, TextureInValidException;

    public void remove(String[] ids) throws NotReadyException, NotFoundException, ZKException;

    /*
     * @Author lz
     * @Description //引擎使用的纹理查询接口，ids逗号间隔
     * @Date 9:17 2020/7/30
     * @Param [ids]
     * @return String
     **/
    public String list(String ids) throws Exception;

    public ITextureService get(String id);

    public String getJSON(String id);
}
