package com.northpool.service.manager.vector_service;

import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.exception.IdFieldValueEmptyException;
import com.northpool.service.config.vector_service.IVectorService;
import com.northpool.service.manager.IClientManager;
import com.northpool.service.manager.abstractclass.ExistsIdException;
import com.northpool.service.manager.abstractclass.NotFoundException;
import com.northpool.service.manager.abstractclass.NotReadyException;
import com.northpool.service.manager.abstractclass.ZKException;

import java.util.List;

public interface IVectorServiceManager  extends IClientManager {
	public List<IVectorService> list(QueryFilter queryFilter) throws Exception;
	public void register(IVectorService t)  throws ExistsIdException,ZKException, IdFieldValueEmptyException, NotReadyException, VectorServiceInvalidException;
	public void unRegister(String id) throws ZKException, NotReadyException, NotFoundException;
	public void update(IVectorService t) throws Exception;
	public void start(String id) throws Exception;
	public void stop(String id) throws Exception;
	public IScroll<IVectorService> scroll(QueryFilter queryFilter);
	public IVectorService get(String id);
	public String getJSON(String id);

    boolean checkVersion(String id, String version);

    public void rename(String oldName, String newName) throws Exception;
}
