package com.northpool.service.manager.vector_service;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.northpool.resources.command.Constants;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.exception.IdFieldValueEmptyException;
import com.northpool.service.config.data_service.FieldsConfig;
import com.northpool.service.config.style.IStyleService;
import com.northpool.service.config.vector_service.ICacheable;
import com.northpool.service.config.vector_service.IVectorService;
import com.northpool.service.config.vector_service.VectorServiceBuilder;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.config.vector_service.layer.LayerBean;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.service.config.vector_service.utfgrid.IUtfgridInfo;
import com.northpool.service.dao.vector_service.VectorServiceMongoDao;
import com.northpool.service.dao.vector_service.VectorServiceZkDao;
import com.northpool.service.manager.abstractclass.*;
import com.northpool.service.manager.style.IStyleManager;
import org.apache.commons.lang3.ObjectUtils;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;

public class VectorServiceManager  extends ServiceManager<IVectorService,VectorServiceBuilder> implements IVectorServiceManager  {
	
	protected static final String MANAGER_ROOT = "vector_service";

	protected static final String MONGO_COLLECTION_NAME = "TAB_MAPENGINE_SERVER_INFO";


	public VectorServiceManager() {
		super("id", new VectorServiceBuilder(), MANAGER_ROOT);
	}


	public void init(){
		super.init();
		this.beanBuilder.setClient(client);
		this.mongoDao = new VectorServiceMongoDao(client.initMongoClient(),  MONGO_COLLECTION_NAME, "id", beanBuilder);
		if (client.getZoo() != null){
			this.zkDao = new VectorServiceZkDao(idFieldName, beanBuilder, table, client, managerRoot, readOnly, this);
			this.zkDao.init();
			try {
				this.zkDao.syncFromZK();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	@Override
	public void register(IVectorService vectorService) throws ExistsIdException, ZKException, IdFieldValueEmptyException,
			NotReadyException, VectorServiceInvalidException {
		this.checkInvalid(vectorService);
		
		super.doAdd(vectorService);
		
	}
	/**
	 * 后续补充
	 * @param vectorService
	 */
	protected void checkInvalid(IVectorService vectorService){
		
	}

	public IVectorService get(String id){
		IVectorService service = super.get(id);
		//service.refresh();
		return service;

	}

	@Override
	public String getJSON(String id) {
		IVectorService vectorService = this.get(id);
		if (vectorService == null){
			return null;
		}

		JSONObject jsonService = (JSONObject)JSON.toJSON(vectorService.getBean());

		this.addLineLabelLayer(jsonService, vectorService);

		this.addFiledsAndStorageToLayers(jsonService, vectorService);

		IStorageInfo storageInfo = vectorService.getStorageInfo();
		if (storageInfo != null){
			this.addStorageInfoToService(jsonService, storageInfo);
		}

		ICacheable cacheInfo = vectorService.getCacheInfo();
		if (cacheInfo != null){
			this.addCacheInfoToService(jsonService, cacheInfo);
		}

		IUtfgridInfo utfgridInfo = vectorService.getUtfgridInfo();
		if (utfgridInfo != null){
			this.addUtfgridInfoToService(jsonService, utfgridInfo);
		}
		return JSON.toJSONString(jsonService, SerializerFeature.DisableCircularReferenceDetect);
	}

	private void addLineLabelLayer(JSONObject jsonService, IVectorService vectorService) {

		Map<String, ILayer> layerMap = vectorService.getLayerMap();
		JSONObject jsonLayerMap = jsonService.getJSONObject("layerMap");

		Iterator<ILayer> iterator = layerMap.values().iterator();
		while (iterator.hasNext()){
			ILayer layer = iterator.next();
			if (layer.getLabel() != null && layer.getLabel().getType() == com.northpool.service.config.Constants.LABEL_TYPE.line){
				JSONObject layerObj = (JSONObject) JSON.toJSON(layer.getBean());
				layerObj.put("labelOnly", true);
				layerObj.put("id", layer.getId() + LayerBean.LINE_LABEL_SUFFIX);
				jsonLayerMap.put(layer.getId() + LayerBean.LINE_LABEL_SUFFIX, layerObj);
				JSONObject maplineLayer =  jsonLayerMap.getJSONObject(layer.getId());
				if (maplineLayer != null){
					maplineLayer.put("haveLabel", false);
					maplineLayer.remove("label");
				}
			}
		}
	}

	private void addUtfgridInfoToService(JSONObject jsonService, IUtfgridInfo utfgridInfo) {
		JSONObject utfObj = (JSONObject) JSON.toJSON(utfgridInfo.getBean());

		IStorageInfo storageInfo = utfgridInfo.getStorageInfo();
		if (storageInfo != null){
			JSONObject storageJsonObj = (JSONObject) JSON.toJSON(storageInfo.getDataSource().getBean());
			storageJsonObj.put("storageName", storageInfo.getStorageName());
			storageJsonObj.put("startLevel", storageInfo.getStartLevel());
			storageJsonObj.put("endLevel", storageInfo.getEndLevel());
			storageJsonObj.put("completed", storageInfo.isCompleted());
			utfObj.put("storageInfo", storageJsonObj);
		}
		jsonService.put("utfgridInfo", utfObj);
	}

	private void addCacheInfoToService(JSONObject jsonService, ICacheable cacheInfo) {
		JSONObject obj = new JSONObject();
			obj.put("dataCacheSource", cacheInfo.getDataCacheSource().getBean());
		obj.put("imgCacheSource", cacheInfo.getImgCacheSource().getBean());
		obj.put("needDataCache", cacheInfo.needDataCache());
		obj.put("needImgCache", cacheInfo.needImgCache());
		obj.put("imgScript", cacheInfo.getImgScript());
		obj.put("dataScript", cacheInfo.getDataScript());
		jsonService.put("cacheInfo", obj);
	}

	private void addStorageInfoToService(JSONObject jsonService, IStorageInfo storageInfo) {
		JSONObject storageJsonObj = (JSONObject) JSON.toJSON(storageInfo.getDataSource().getBean());
		storageJsonObj.put("storageName", storageInfo.getStorageName());
		storageJsonObj.put("startLevel", storageInfo.getStartLevel());
		storageJsonObj.put("endLevel", storageInfo.getEndLevel());
		storageJsonObj.put("completed", storageInfo.isCompleted());
		jsonService.put("storageInfo", storageJsonObj);
	}

	private void addFiledsAndStorageToLayers(JSONObject jsonService, IVectorService vectorService) {
		JSONObject layerMap = jsonService.getJSONObject("layerMap");
		layerMap.forEach((layerName, layer) -> {
			String name = layerName;
			if (layerName.endsWith(LayerBean.LINE_LABEL_SUFFIX)){
				name = layerName.substring(0, layerName.length() - 3);
			}
			ILayer iLayer = vectorService.getLayerMap().get(name);
			List<FieldsConfig> fieldsConfigs = vectorService.getLayerFields(iLayer);
			String idFieldName = vectorService.getLayerIdFieldName(iLayer);
			String ideFieldType = vectorService.getLayerIdFieldType(iLayer);
			String geometryType = vectorService.getLayerGeometryType(iLayer);
			JSONObject jsonLayer = (JSONObject) layer;
			jsonLayer.put("fields", fieldsConfigs);
			jsonLayer.put("geometryType", geometryType);
			jsonLayer.put("idField", idFieldName);
			jsonLayer.put("idFieldType", ideFieldType);
			IStorageInfo storageInfo = iLayer.getLevelMap().values().iterator().next().getDataSet().getDataService().getStorageInfo();
			if (storageInfo == null){
				return;
			}
			JSONObject storageJsonObj = (JSONObject) JSON.toJSON(storageInfo.getDataSource().getBean());
			if (layerName.endsWith(LayerBean.LINE_LABEL_SUFFIX)){
				storageJsonObj.put("storageName", storageInfo.getLabelStorageName());
			}else {
				storageJsonObj.put("storageName", storageInfo.getStorageName());
			}
			storageJsonObj.put("startLevel", storageInfo.getStartLevel());
			storageJsonObj.put("endLevel", storageInfo.getEndLevel());
			storageJsonObj.put("completed", storageInfo.isCompleted());
			jsonLayer.put("storageInfo", storageJsonObj);
		});
	}

	@Override
	public void unRegister(String id) throws ZKException, NotReadyException, NotFoundException {
		// TODO Auto-generated method stub
		super.doRemove(id);
	}

	@Override
	public void update(IVectorService vectorService) throws Exception {
		// TODO Auto-generated method stub
		//vectorService.getBean().setVersion(new Date().getTime() + "");//每次更新修改版本号
		this.checkInvalid(vectorService);
		super.doUpdate(vectorService);
	}

	@Override
	public boolean checkVersion(String id, String version){
		IVectorService vectorService = this.get(id);
		if(vectorService != null) {
			return ObjectUtils.equals(version, vectorService.getVersion());
		}
		return false;
	}

	@Override
	public void rename(String oldName, String newName) throws Exception {
		IVectorService old = this.get(oldName);
		if (old == null){
			throw new RuntimeException("服务 " + oldName + " 不存在");
		}

		IVectorService newService = this.get(newName);
		if (newService != null){
			throw new RuntimeException("服务 " + newService + " 已存在");
		}
		IStyleManager styleManager = client.getStyleManager();
		QueryFilter filter = new QueryFilter();
		filter.addFilter("ownServer", Constants.OPERATION.EQ, oldName);
		List<IStyleService> styles = styleManager.list(filter);
		for (int i = 0; i < styles.size(); i++) {
			IStyleService style = styles.get(i);
			style.getBean().setOwnServer(newName);
			styleManager.update(style);
		}
		IStorageInfo storageInfo = old.getStorageInfo();
		if (storageInfo != null){
			storageInfo.rename(newName);
		}

		IUtfgridInfo utfgridInfo = old.getUtfgridInfo();
		if (utfgridInfo != null){
			IStorageInfo utfStorageInfo = utfgridInfo.getStorageInfo();
			if (utfStorageInfo != null){
				utfStorageInfo.rename(newName + StorageInfoBean.STORAGE_SUFFIX);
			}
		}
		this.unRegister(oldName);
		old.getBean().setId(newName);
		this.register(old);
	}

	public CompletableFuture addListener(Consumer callback, Function exception){
		CompletableFuture future = CompletableFuture.supplyAsync(()->{
/*			try {
				Thread.sleep(3000l);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}*/
			return "haha";
		});
		if (callback != null){
			future.thenAcceptAsync(callback);
		}
		if (exception != null){
			future.exceptionally(exception);
		}
		return future;
	}

	
}
