package com.northpool.service.netty.socket;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.northpool.service.client.Client;
import com.northpool.service.manager.IClientManager;
import com.northpool.service.manager.cell.ITileDataCellManager;
import com.northpool.service.manager.data_service.IDataServiceManager;
import com.northpool.service.manager.data_sources.IDataSourcesManager;
import com.northpool.service.manager.font.IFontManager;
import com.northpool.service.manager.style.IStyleManager;
import com.northpool.service.manager.texture.ITextureManager;
import com.northpool.service.manager.vector_service.IVectorServiceManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;

public class SocketHandler extends SimpleChannelInboundHandler<Object> {

    private Client client;
    private HashMap<String, Method> methodMap;
    private HashMap<String, IClientManager> managerMap;


    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object user) throws Exception {
        ByteBuf byteBuf = (ByteBuf) user;
        int len = byteBuf.maxCapacity();
        byte[] data = new byte[len];
        for (int i = 0; i < len; i++) {
            data[i] = byteBuf.getByte(i);
        }
        String str = new String(data,"utf-8");
        JSONArray arr = JSON.parseArray(str);
        List<Object> params = arr.subList(0, arr.size() - 2);
        String markId = (String) arr.get(arr.size() - 1);
        String methodKey = (String) arr.get(arr.size() - 2);
        String managerName = methodKey.substring(0, methodKey.indexOf("_"));
        IClientManager manager = this.managerMap.get(managerName);
        Method method = this.methodMap.get(methodKey);
        byte[] markByte = markId.getBytes("utf-8");
        Object result = method.invoke(manager, params);
        byte[] bytedata = null;
        if (result instanceof byte[]){
            bytedata = (byte[]) result;
        }else if (result instanceof String){
            bytedata = ((String)result).getBytes("utf-8");
        }
        byte[] allData = new byte[markId.length() + bytedata.length];
        System.arraycopy(markByte, 0, allData, 0, markByte.length);
        System.arraycopy(bytedata, 0, allData, markByte.length, bytedata.length);
        ctx.writeAndFlush(allData);
    }

    public void setClient(Client client){
        this.client = client;
    }

    public void init(){
        methodMap = new HashMap<>();
        IDataSourcesManager dataSourcesManager = client.getDataSourcesManager();
        managerMap.put("IDataSourcesManager", dataSourcesManager);
        Method[] methods = IDataSourcesManager.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; i++) {
            Method method = methods[i];
            methodMap.put("IDataSourcesManager_"+method.getName(), method);
        }

        IDataServiceManager dataServiceManager = client.getDataServiceManager();
        managerMap.put("IDataServiceManager", dataServiceManager);
        methods = IDataServiceManager.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; i++) {
            Method method = methods[i];
            methodMap.put("IDataServiceManager_"+method.getName(), method);
        }

        IVectorServiceManager vectorServiceManager = client.getVectorServiceManager();
        managerMap.put("IVectorServiceManager", vectorServiceManager);
        methods = IVectorServiceManager.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; i++) {
            Method method = methods[i];
            methodMap.put("IVectorServiceManager_"+method.getName(), method);
        }


        IStyleManager styleManager = client.getStyleManager();
        managerMap.put("IStyleManager", styleManager);

        methods = IStyleManager.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; i++) {
            Method method = methods[i];
            methodMap.put("IStyleManager_"+method.getName(), method);
        }

        ITextureManager textureManager = client.getTextureManager();
        managerMap.put("ITextureManager", textureManager);
        methods = ITextureManager.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; i++) {
            Method method = methods[i];
            methodMap.put("ITextureManager_"+method.getName(), method);
        }


        IFontManager fontManager = client.getFontManager();
        managerMap.put("IFontManager", fontManager);
        methods = IFontManager.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; i++) {
            Method method = methods[i];
            methodMap.put("IFontManager_"+method.getName(), method);
        }

        ITileDataCellManager tileDataCellManager = client.getTileDataCellManager();
        managerMap.put("ITileDataCellManager", tileDataCellManager);
        methods = ITileDataCellManager.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; i++) {
            Method method = methods[i];
            methodMap.put("ITileDataCellManager_"+method.getName(), method);
        }
    }

    public static void main(String[] args) {
        String a = "ITileDataCellManager_aaa";
        System.out.println(a.substring(0, a.indexOf("_")));
    }

}