//package com.northpool.service.xmlloader;
//
//import java.io.File;
//import java.io.IOException;
//import java.io.InputStream;
//import java.util.HashMap;
//import java.util.List;
//import java.util.Map;
//
//import javax.xml.XMLConstants;
//import javax.xml.transform.stream.StreamSource;
//import javax.xml.validation.Schema;
//import javax.xml.validation.SchemaFactory;
//import javax.xml.validation.Validator;
//
//import org.dom4j.Element;
//import org.xml.sax.SAXException;
//
//
//
////import com.northpool.server.ResourcePool;
//import com.northpool.common.reflect.Bean;
//import com.northpool.common.reflect.ReflectFindException;
//import com.northpool.core.dialect.Impl.DynamicBeanDialect;
//
//import com.northpool.resource.Constants.DATA_SOURCE_TYPE;
//import com.northpool.resource.datasource.IDataSource;
//import com.northpool.resource.datasource.db.DbDataSource;
//import com.northpool.resource.datasource.mongo.MongodbDataSource;
//import com.northpool.resource.datatable.db.DBDataTableException;
//import com.northpool.resource.datatable.db.DBDataTableManager;
//import com.northpool.service.config.vectorservice.bean.DataSetBean;
//import com.northpool.service.config.vectorservice.dataset.IDataSet;
//import com.northpool.spatial.grid.Constants.GRID_BASE;
//import com.northpool.spatial.grid.Constants.GRID_TYPE;
//import com.northpool.spatial.grid.Constants.GRID_UNIT;
//import com.northpool.spatial.grid.GridManager;
//import com.northpool.spatial.grid.QuadtreeGrid;
//
//
//public abstract class AbstractXmlLoader {
//	
//	
//	protected DBDataTableManager dbDataTableManager = new DBDataTableManager();
//	
////	protected ResourcePool resourcePool;
//	
//	protected String validateXMLPath;
//	
//	abstract protected String getValidateXMLPath();
//	
//	
//	
//	/**
//	 * 解析数据源
//	 * 
//	 * @param info
//	 * @return
//	 */
//	protected IDataSource createDataSource(Element info) {
//		String type = info.elementText("Type");
//		if ("oracle".equalsIgnoreCase(type) || "postgres".equalsIgnoreCase(type) || "postgre".equalsIgnoreCase(type)) {
//			DbDataSource dbDataSource = new DbDataSource();
//			this.getInfoByStr(info, dbDataSource, "Url,Id,User,Password");
//			dbDataSource.setType(type);
//			//在RESOURCE_POOL中注册
//			return dbDataSource;
//		}
//		if ("mongodb".equalsIgnoreCase(type)) {
//			MongodbDataSource mongodbDataSource = new MongodbDataSource();
//			this.getInfoByStr(info, mongodbDataSource, "Ip,Namespace,Id,User,Password");
//			Integer port;
//			try{
//				port = Integer.valueOf(info.elementText("Port"));
//			}catch(Exception e){
//				port = null;
//			}
//			if(port == null){
//				try{
//					port = Integer.valueOf(info.elementText("Post"));
//				}catch(Exception e){
//					port = null;
//				}
//			}
//			if(port == null){
//				throw new RuntimeException("port必须为空且必须是整数");
//			}
//			mongodbDataSource.setPort(port);
//			
//			return mongodbDataSource;
//		}
//		throw new RuntimeException("现在不支持 " + type + " 的数据库");
//	}
//
//	/**
//	 * 从XML中去信息
//	 * 
//	 * @param item
//	 * @param t
//	 * @param fieldsStr
//	 *            字段,已逗号隔开
//	 */
//	protected <T> void getInfoByStr(Element item, T t, String fieldsStr) {
//		String[] fieldArr = fieldsStr.split(",");
//		for (String field : fieldArr) {
//			String value = null;
//
//			if ("Id".equalsIgnoreCase(field)) {
//				value = item.attributeValue("Id");
//				if(value == null){
//					value = "_tmp";
//				}
//			} else {
//				value = item.elementText(field);
//			}
//			if (value != null) {
//				value = value.trim();
//			}else{
//				throw new RuntimeException("处理" + field + "出错," + field + "不能为空值");
//			}
//			if (field.startsWith("encode(")) {
//				field = field.replace("encode(", "").replace(")", "");
//				value = item.elementText(field);
//				if (value != null) {
//					if(!"".equalsIgnoreCase(value)){
//						value = DynamicBeanDialect.getInstance().encode(value.trim());
//					}
//				}
//			}
//
//			field = field.substring(0, 1).toLowerCase() + field.substring(1);
//			try {
//				Bean.setSingleObjectValueByFieldName(t, field, value);
//			} catch (ReflectFindException e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//				throw new RuntimeException("处理" + field + "出错");
//			}
//		}
//	}
//	
//	/**
//	 * 解析DataSet
//	 * 
//	 * @param info XML节点
//	 * @param dataSource 数据源
//	 * @param dataSourceMap 数据源的MAP （兼容原有写法，如果map不为空，则为原有写法）
//	 * @throws DBDataTableException 
//	 * 
//	 */
//	protected DataSetBean createDBDataSet(Element info,DbDataSource dbDataSource) throws DBDataTableException {
//
//	
//		String dataSourceId = dbDataSource.getId();
//		String tableName = info.elementText("Tablename");
//		String idField = info.elementText("IdField");
//		String spatialField = info.elementText("ShapeField");
//		Integer srid = this.getInteger(info,"Srid");
//		//DBSpatial dbTable = this.dbDataTableManager.getDBSpatial(dbDataSource, tableName, idField, spatialField, srid);
//		String fields = info.elementText("Fields");
//		String mark = info.attributeValue("Id");
//		
//		
//		DataSetBean dataSetBean = new DataSetBean();
//		
//		dataSetBean.setDataSourceId(dbDataSource.getId());
//		dataSetBean.setIdField(idField);
//		dataSetBean.setSrid(srid);
//		dataSetBean.setSpatialField(spatialField);
//		dataSetBean.setFields(fields.split(","));
//		dataSetBean.setTableName(tableName);
//
//		String spatialFilter = info.elementText("SpatialFilter");
//		if(spatialFilter != null){
//			if (!"".equalsIgnoreCase(spatialFilter)) {
//				dataSetBean.setSpatialFilter(spatialFilter);
//			}
//		}
//		
//		String filter = info.elementText("Filter");
//		if(filter != null){
//			if (!"".equalsIgnoreCase(filter)) {
//				dataSetBean.setFilter(filter);
//			}
//		}
//			
//		// 加入排序处理
//
//		/*String sortStr = info.elementText("Sort");
//		if (sortStr != null) {
//			if (!"".equalsIgnoreCase(sortStr)) {
//				String[] sortArr = sortStr.split("=");
//				if (sortArr.length != 2) {
//					throw new RuntimeException("数据集 " + dataSetBean.getMark() + " 设置排序字段格式错误 ，格式应为 {field}=asc格式");
//				}
//				if ((!sortArr[1].equalsIgnoreCase("asc")) && (!sortArr[1].equalsIgnoreCase("desc"))) {
//					throw new RuntimeException("数据集 " +dataSetBean.getMark() + " 设置排序字段格式错误 ，格式应为 {field}=asc格式");
//				}
//				
//				dataSetBean.setSortFiled(sortField);
//				dataSetBean.setSort(sortArr[1]);
//
//			}
//		}*/
//		
//		return dataSetBean;
//	}
//	
//	
//	protected Map<String, IDataSet> getDataSetMap(Element root, Map<String, IDataSource> dataSourceMap) throws DBDataTableException {
//		Map<String, IDataSet> dataSetMap = new HashMap<String, IDataSet>();
//		@SuppressWarnings("unchecked")
//		List<Element> items = root.element("DataSets").elements();
//		for (Element item : items) {
//			
//			IDataSet dataSet = this.createDataSet(item, dataSourceMap);
//			if(dataSet != null){
//				dataSetMap.put(dataSet.getId(), dataSet);
//			}
//
//		}
//		return dataSetMap;
//	}
//	
//	
//	protected IDataSet createDataSet(Element item,Map<String, IDataSource> dataSourceMap) throws DBDataTableException{
//		String dataSourceName = item.elementText("DataSource");
//		IDataSource dataSource = dataSourceMap.get(dataSourceName);
//		if (dataSource == null) {
//			throw new RuntimeException("没有找到名称为 " + dataSourceName + " 数据源");
//		}
//		DATA_SOURCE_TYPE type = dataSource.getDataSourceType();
//		DataSetBean dataSetBean;
//		switch(type){
//			case oracle:
//				dataSetBean = this.createDBDataSet(item, (DbDataSource)dataSource);
//				return dataSetBean;
//			case postgres:
//				dataSetBean = this.createDBDataSet(item, (DbDataSource)dataSource);
//				return dataSetBean;
//		}
//		throw new RuntimeException("目前不支持数据源:" + type.name());
//	}
//	
//	
//	
//	
//	protected Integer getInteger(Element info,String elementName){
//		String valueStr = info.elementText(elementName);
//		if(valueStr == null){
//			valueStr = info.attributeValue(elementName);
//		}
//		
//		if(valueStr == null){
//			return null;
//		}
//		
//		if("".equalsIgnoreCase(valueStr)){
//			return null;
//		}
//		
//		try{
//			Integer value = Integer.valueOf(valueStr);
//			return value;
//		}catch(Exception e){
//			throw new RuntimeException("xml中" + elementName + "必须是Integer类型");
//		}
//	}
//	
//	protected Double getDouble(Element info,String elementName){
//		String valueStr = info.elementText(elementName);
//		if(valueStr == null){
//			valueStr = info.attributeValue(elementName);
//		}
//		
//		if(valueStr == null){
//			return null;
//		}
//		
//		if("".equalsIgnoreCase(valueStr)){
//			return null;
//		}
//		
//		try{
//			Double value = Double.valueOf(valueStr);
//			return value;
//		}catch(Exception e){
//			throw new RuntimeException("xml中" + elementName + "必须是Double类型");
//		}
//	}
//	
//	
//	protected Boolean getBoolean(Element info,String elementName){
//		String valueStr = info.elementText(elementName);
//		if(valueStr == null){
//			valueStr = info.attributeValue(elementName);
//		}
//		
//		if(valueStr == null){
//			return null;
//		}
//		
//		if("".equalsIgnoreCase(valueStr)){
//			return null;
//		}
//		
//		try{
//			Boolean value = Boolean.valueOf(valueStr);
//			return value;
//		}catch(Exception e){
//			throw new RuntimeException("xml中" + elementName + "必须是Boolean类型");
//		}
//	}
//	
//	private void validateXMLSchema(InputStream inXMl) throws SAXException, IOException{
//		SchemaFactory factory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
//        Schema schema;
//		schema = factory.newSchema(new File(this.getValidateXMLPath()));
//		Validator validator = schema.newValidator();
//        validator.validate(new StreamSource(inXMl));
//	}
//	
//	
//	public void validateXML(InputStream inXMl) throws Exception{
//		try {
//			this.validateXMLSchema(inXMl);
//			inXMl.markSupported();
//		} catch (SAXException e1) {
//			// TODO Auto-generated catch block
//			throw new Exception("xml格式错误:" + e1.toString().replaceAll("org.xml.sax.SAXParseException;", ""));
//		} catch (IOException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//			throw new Exception("没有找到XML校验文件");
//		} finally{
//			inXMl.close();
//		}
//	}
//	
//	protected QuadtreeGrid createGrid(String gridUnitStr,String gridBaseStr,String gridTypeStr){
//		
//		GRID_UNIT unit;
//		GRID_BASE base;
//		GRID_TYPE type;
//		if(GRID_UNIT.degree.name().equalsIgnoreCase(gridUnitStr)){
//            unit = GRID_UNIT.degree;
//        }else if(GRID_UNIT.meter.name().equalsIgnoreCase(gridUnitStr)){
//            unit = GRID_UNIT.meter;
//        }else if("meters".equalsIgnoreCase(gridUnitStr)){
//            unit = GRID_UNIT.meter;
//        }else if("degrees".equalsIgnoreCase(gridUnitStr)){
//        	unit = GRID_UNIT.degree;
//        }else{
//            throw new RuntimeException("格网的单位只能为meter或者是degree");
//        }
//
//		base = GRID_BASE.base512;
//
//        if(GRID_TYPE.tdt.name().contentEquals(gridTypeStr)){
//            type = GRID_TYPE.tdt;
//        }else{
//            throw new RuntimeException("格网的类型只能是tdt");
//        }
//
//        // 根据坐标系计算瓦片金字塔结构
//        QuadtreeGrid gridTree = GridManager.getQuadtreeGrid(unit, base, type);
//        return gridTree;
//
//	}
//	
//	
//	
//}
