package com.northpool.service.config.data_service;

import com.northpool.resources.datatable.FieldEncoder;
import com.northpool.resources.datatable.IField;
import com.northpool.resources.datatable.ISpatialField;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.datatable.operate.ITableOperator;
import com.northpool.service.client.Client;
import com.northpool.service.config.Constants.SERVICE_TYPE;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.layer.LayerBean;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.service.config.vector_service.storage.StorageInfoShell;
import com.northpool.spatial.Constants;
import org.bson.Document;

import java.util.*;
import java.util.stream.Collectors;

public class DataServiceShell  implements IDataService{

	private Client client;
	
	private DataServiceBean dataService;

	private IStorageInfo storageInfo;

	private Map<String, String> fieldsMap;
	
	public DataServiceShell(Client client,DataServiceBean dataService){
		this.client = client;
		this.dataService = dataService;
		this.storageInfo = this.createStorageInfo(dataService.getStorageInfo());
	}

	public String getMark() {
		return mark() ;
	}
	
	
	@Override
	public String mark() {
		// TODO Auto-generated method stub
		return dataService.id;
	}


	@Override
	public void start() {
		// TODO Auto-generated method stub
		this.dataService.state = STATE_TYPE.run;
	}


	@Override
	public void stop() {
		// TODO Auto-generated method stub
		this.dataService.state = STATE_TYPE.stop;
	}


	@Override
	public String state() {
		// TODO Auto-generated method stub
		return this.dataService.state.name();
	}


	@Override
	public STATE_TYPE getState() {
		// TODO Auto-generated method stub
		return this.dataService.state;
	}


	@Override
	public void rollback(STATE_TYPE state) {
		// TODO Auto-generated method stub
		this.dataService.state = state;
	}
	

	@Override
	public Boolean getReadOnly() {
		// TODO Auto-generated method stub
		return dataService.readonly;
	}

	@Override
	public String getId() {
		// TODO Auto-generated method stub
		return dataService.id;
	}

	@Override
	public String getVersion() {
		return dataService.version;
	}

	@Override
	public void setVersion(String version) {
		dataService.setVersion(version);
	}

	@Override
	public SERVICE_TYPE getServiceType() {
		// TODO Auto-generated method stub
		return dataService.serviceType;
	}

	@Override
	public String toJson() {
		// TODO Auto-generated method stub
		this.getFields();
		return dataService.toJson();
	}

	private IStorageInfo createStorageInfo(StorageInfoBean storageInfo){
		if (storageInfo != null){
			return new StorageInfoShell(this.client, storageInfo);
		}
		return null;
	}

	@Override
	public void addStorageInfo(IStorageInfo storageInfo) {
		this.storageInfo = storageInfo;
		this.getBean().setStorageInfo(storageInfo.getBean());
	}

	@Override
	public IStorageInfo getStorageInfo() {
		return this.storageInfo;
	}

	@Override
	public String getStorageName() {
		return this.dataService.getName() + "_" + this.dataService.getId();
	}

	@Override
	public String getLabelStorageName() {
		return this.dataService.getName() + LayerBean.LABEL_SUFFIX + "_" + this.dataService.getId();
	}

	@Override
	public Client getClient() {
		return this.client;
	}

	@Override
	public void setFilter(String filter) {
		this.dataService.setFilter(filter);
	}


	@Override
	public List<FieldsConfig> getFields() {
		if (dataService.getFields() == null || dataService.getFields().isEmpty()){
			List<FieldsConfig> fields = new ArrayList<>();
			Map<String, IField> fieldsMap = this.getFieldMap();
			IField idField = this.getIdFieldByTable();
			ISpatialField spatialField = this.getSpatialFieldByTable();
			FieldsConfig fieldsConfig = null;
			boolean isId = false;
			Iterator<String> it = this.dataService.aliasMap.values().iterator();
			int index = 0;
			while (it.hasNext()){
				String fieldName = it.next();
				if (fieldName.equals(spatialField.getFieldName())){//空间字段不要
					continue;
				}
				fieldsConfig = new FieldsConfig();
				fieldsConfig.setIndex(index);
				fieldsConfig.setName(fieldName);
				fieldsConfig.setRemarks(fieldsMap.get(fieldName).getRemarks());
				isId = fieldName.equals(idField.getFieldName());
				fieldsConfig.setId(isId);
				fieldsConfig.setType(fieldsMap.get(fieldName).getType().name().toLowerCase());
				fields.add(fieldsConfig);
				index++;
			}
			this.dataService.setFields(fields);
		}

		if (this.dataService.getGeoType() == null){
			ISpatialField spatialField = this.getSpatialFieldByTable();
			this.dataService.setGeoType(spatialField.getGeoType().name());
		}
		return this.dataService.getFields();
	}


	@Override
	public IDataSourceInService getDataSource() {
		// TODO Auto-generated method stub
		String dataSourceId = this.dataService.dataSourceId;
		IDataSourceInService dataSource = this.client.getDataSourcesManager().get(dataSourceId);
		if(dataSource == null){
			throw new RuntimeException(String.format("没有dataSourceId为 %s 的数据源",dataSourceId));
		}
		return dataSource;
	}

	@Override
	public String getDataSourceId() {
		return this.dataService.getDataSourceId();
	}


	protected ITableOperator getBuilder(){
		IDataSourceInService dataSource = this.getDataSource();
		try {
			return dataSource.getTableBuilder(this.dataService.tableName);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}
	

	@Override
	public ISpatialField getSpatialField() {
		// TODO Auto-generated method stub
		ITableOperator builder = this.getBuilder();
		IColumn column = builder.getColumnMap().get(this.dataService.getSpatialOriginFieldName());
		if (column == null){
			column = builder.getColumnMap().get(this.dataService.getSpatialOriginFieldName().toUpperCase());
		}
		if(column == null){
			new RuntimeException(String.format("%s中没有找到字段%s", builder.mark(),this.dataService.getSpatialOriginFieldName()));
		}
		final IColumn spatialColumn = column;
		List<ISpatialField> i = this.dataService.getAliasMap().entrySet().stream().filter( entry -> {
			String fieldOrigin = entry.getKey();
			if(fieldOrigin.equalsIgnoreCase(this.dataService.getSpatialOriginFieldName())){
				return true;
			}else{
				return false;
			}
		}).map( entry-> {
			return IField.createSpatialField(entry.getValue(), spatialColumn);
			
		}).collect(Collectors.toList());
	
		if(i.isEmpty()){
			throw new RuntimeException(String.format("%s中没有找到字段%s", builder.mark(),this.dataService.getSpatialOriginFieldName()));
		}
		
		return i.get(0);
	}

	@Override
	public ISpatialField getSpatialFieldByTable() {
		// TODO Auto-generated method stub
		ITableOperator builder = this.getBuilder();
		IColumn column = builder.getColumnMap().get(this.dataService.getSpatialOriginFieldName());
		if (column == null){
			column = builder.getColumnMap().get(this.dataService.getSpatialOriginFieldName().toUpperCase());
		}
		if(column == null){
			new RuntimeException(String.format("%s中没有找到字段%s", builder.mark(),this.dataService.getSpatialOriginFieldName()));
		}
		final IColumn spatialColumn = column;
		List<ISpatialField> i = this.dataService.getAliasMap().entrySet().stream().filter( entry -> {
			String fieldOrigin = entry.getKey();
			if(fieldOrigin.equalsIgnoreCase(this.dataService.getSpatialOriginFieldName())){
				return true;
			}else{
				return false;
			}
		}).map( entry-> {
			return IField.createSpatialField(entry.getValue(), spatialColumn);

		}).collect(Collectors.toList());

		if(i.isEmpty()){
			throw new RuntimeException(String.format("%s中没有找到字段%s", builder.mark(),this.dataService.getSpatialOriginFieldName()));
		}

		return i.get(0);
	}

	@Override
	public Constants.GEO_TYPE getGeoType() {
		if (this.dataService.getGeoType() == null){
			ISpatialField spatialField = this.getSpatialFieldByTable();
			this.dataService.setGeoType(spatialField.getGeoType().name());
		}
		return Constants.GEO_TYPE.valueOf(this.dataService.getGeoType());
	}


	@Override
	public String getSpatialFieldOriName() {
		return this.dataService.getSpatialOriginFieldName();
	}

	@Override
	public String getSpatialFieldName() {
		return this.dataService.getSpatialFieldName();
	}


	private IField getIdFieldByTable() {

		ITableOperator builder = this.getBuilder();
		IColumn column = builder.getColumnMap().get(builder.getPKColumn());
		if(column == null){
			new RuntimeException(String.format("%s中没有找到字段%s", builder.mark(),builder.getPKColumn()));
		}
		List<IField> i = this.dataService.getAliasMap().entrySet().stream().filter( entry -> {
			String fieldOrigin = entry.getKey();
			if(fieldOrigin.equalsIgnoreCase(builder.getPKColumn())){
				return true;
			}else{
				return false;
			}
		}).map( entry-> {
			return IField.createField(entry.getValue(), column);
			
		}).collect(Collectors.toList());
	
		if(i.isEmpty()){
			throw new RuntimeException(String.format("%s中没有找到字段%s", builder.mark(),builder.getPKColumn()));
		}
		
		return i.get(0);
	}

	public FieldsConfig getIdField() {
		List<FieldsConfig> fieldsConfigs = this.getFields();
		return fieldsConfigs.stream().filter(fieldsConfig -> fieldsConfig.getId()).findFirst().get();
	}


	@Override
	public Map<String, IField> getFieldMap() {
		// TODO Auto-generated method stub
		ITableOperator builder = this.getBuilder();
		Map<String,IField> map = new LinkedHashMap<>();
		this.dataService.getAliasMap().entrySet().forEach( entry ->{
			String fieldAlias = entry.getValue();
			String fieldOrigin = entry.getKey();
			IColumn column = builder.getColumnMap().get(fieldOrigin);
			if (column == null){
				column = builder.getColumnMap().get(fieldOrigin.toUpperCase());
			}
			map.put(fieldAlias, IField.createField(entry.getValue(), column));
		});		
		return map;
	}




	@Override
	public String getIdFieldName() {
		return this.getIdField().getName();
	}

	@Override
	public Map<String, String> getAliasMap() {
		// TODO Auto-generated method stub
		return this.dataService.aliasMap;
	}

	@Override
	public String[] getAliasFiledArr() {
		// TODO Auto-generated method stub
		/*List<FieldsConfig> fieldsConfigs = this.getFields();
		Map<String, String> aliasMap = this.dataService.getAliasMap();
		String[] arr = fieldsConfigs.stream().map(fieldsConfig -> aliasMap.get(aliasMap.get(fieldsConfig.getName()))).toArray(String[]::new);*/
		String[] arr = this.dataService.getAliasMap().entrySet().stream().map( entry-> {
			return entry.getValue();
		}).toArray(String[]::new);
		return arr;
	}

	@Override
	public DataServiceBean getBean() {
		// TODO Auto-generated method stub
		return this.dataService;
	}

	@Override
	public String getTableName() {
		// TODO Auto-generated method stub
		return this.dataService.tableName;
	}

	@Override
	public String getName() {
		return this.dataService.getName();
	}

	@Override
	public ITable getTable() throws Exception  {
		// TODO Auto-generated method stub
		IDataSourceInService dataSource = this.getDataSource();
		List<FieldsConfig> fieldsConfigs = this.getFields();
		if (this.fieldsMap == null){
			this.fieldsMap = this.revertMapKV(this.getAliasMap());
		}
		List<String> fieldNames = fieldsConfigs.stream().map(fieldsConfig -> fieldsMap.get(fieldsConfig.getName())).collect(Collectors.toList());
		fieldNames.add(this.getSpatialFieldOriName());//把空间字段放在最后，确保前面的属性字段顺序与数据服务元数据中的一致，避免切片和元数据字段顺序不一致的问题
		String[] fieldsArr = fieldNames.stream().toArray(String[]::new);
		ITable table = dataSource.getTableBuilder(this.dataService.tableName).getTable(fieldsArr);
		return table;
	}

	private Map<String, String> revertMapKV(Map<String, String> map){
		if (map == null){
			return null;
		}
		Map<String, String> result = new HashMap<>(map.size());
		Iterator<String> iterator = map.keySet().iterator();
		String key = null;
		while (iterator.hasNext()){
			key = iterator.next();
			result.put(map.get(key), key);
		}
		return result;
	}

	@Override
	public void refresh() {
		IDataService dataService = this.client.getDataServiceManager().get(this.getId());
		if (dataService == null){
			return;//此处应抛出异常
		}
		this.dataService = dataService.getBean();
		IDataSourceInService dataSourceInService = this.getDataSource();
		dataSourceInService.refresh();
	}




	public FieldEncoder getFieldEncoder(){
		Map<String, String> aliasMap = this.getAliasMap();
		
		
		return new FieldEncoder(){

			@Override
			public String encode(String fieldInDB) {
				// TODO Auto-generated method stub
				return aliasMap.get(fieldInDB.toLowerCase());
			}

			@Override
			public String getFieldEncoderName() {
				// TODO Auto-generated method stub
				return "";
			}
			
		};
	}


	@Override
	public Document toDocument() {
		return Document.parse(this.toJson());
	}

	@Override
	public boolean equals(Object o) {
		DataServiceShell bean = (DataServiceShell) o;
		return this.dataService.equals(bean.getBean());
	}
}
