package com.northpool.service.config.font;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.northpool.service.config.Constants;
import org.apache.commons.lang3.StringUtils;

public class FontBean {

    protected String filename;

    protected String family;

    protected Constants.FONT_STYLE style;

    protected Constants.FONT_WEIGHT weight;

    protected Constants.FONT_FILE_TYPE fileType;

    @JSONField(serialize = false)
    protected byte[] content;

    protected String version;

    //是否是后端默认字体
    protected Boolean defaultFont = false;

    //是否是前端生僻字
    protected Boolean foreendUnCommon = false;

    //是否是后端生僻字
    protected Boolean backendUnCommon = false;


    public String getId() {
        if (StringUtils.isEmpty(this.filename)){
            this.filename = this.getFilename();
        }
        return this.filename;
    }

    public void setId(String id) {
        this.filename = id;
    }

    public String getFilename() {
        if (StringUtils.isEmpty(this.filename)){
            this.filename = family + "_" + style + "_" + weight + "." + fileType;
        }
        return filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFamily() {
        return family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public Constants.FONT_STYLE getStyle() {
        return style;
    }

    public void setStyle(Constants.FONT_STYLE style) {
        this.style = style;
    }

    public Constants.FONT_WEIGHT getWeight() {
        return weight;
    }

    public void setWeight(Constants.FONT_WEIGHT weight) {
        this.weight = weight;
    }

    public Constants.FONT_FILE_TYPE getFileType() {
        return fileType;
    }

    public void setFileType(Constants.FONT_FILE_TYPE fileType) {
        this.fileType = fileType;
    }

    public byte[] getContent() {
        return content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toJson(){
        return JSON.toJSONString(this);
    }

    public Boolean isDefaultFont() {
        return defaultFont;
    }

    public void setDefaultFont(Boolean defaultFont) {
        this.defaultFont = defaultFont;
    }

    public Boolean isForeendUnCommon() {
        return foreendUnCommon;
    }

    public void setForeendUnCommon(Boolean foreendUnCommon) {
        this.foreendUnCommon = foreendUnCommon;
    }

    public Boolean isBackendUnCommon() {
        return backendUnCommon;
    }

    public void setBackendUnCommon(Boolean backendUnCommon) {
        this.backendUnCommon = backendUnCommon;
    }
}
