package com.northpool.service.dao.data_sources;

import com.northpool.service.client.Client;
import com.northpool.service.config.data_source.DataSourceBuilder;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.dao.AbstractZkDao;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.TransactionOp;

import java.util.List;

public class DataSourcesZkDao extends AbstractZkDao<IDataSourceInService, DataSourceBuilder> {
    public DataSourcesZkDao(String idFieldName, DataSourceBuilder beanBuilder, QueryHashTableHeap<String, IDataSourceInService> table, Client client, String managerRoot, Boolean readOnly) {
        super(idFieldName, beanBuilder, table, client, managerRoot, readOnly);
    }

    @Override
    protected void AddExtendsInfo2BeanNode(String path, List<CuratorOp> iList, TransactionOp transaction, IDataSourceInService dataSource) throws Exception {
        // TODO Auto-generated method stub
        CuratorOp createOp = transaction.create().forPath(path + "/data_source_type",dataSource.getDataSourceType().name().getBytes());
        iList.add(createOp);
    }
}
