package com.northpool.service.xmlloader.vectorservice;

import com.northpool.commons.reflect.Bean;
import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.datatable.operate.ITableOperator;
import com.northpool.resources.exception.IdFieldValueEmptyException;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_service.DataServiceBean;
import com.northpool.service.config.data_service.DataServiceInvalidException;
import com.northpool.service.config.data_service.DataServiceShell;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.dataset.DataSetBean;
import com.northpool.service.manager.abstractclass.ExistsIdException;
import com.northpool.service.manager.abstractclass.ZKException;
import com.northpool.service.manager.data_service.IDataServiceManager;
import org.dom4j.Element;
import org.xml.sax.SAXException;

import javax.xml.XMLConstants;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public abstract class AbstractXmlLoader {
	
	protected Client client;
	
	protected String validateXMLPath;
	
	abstract protected String getValidateXMLPath();
	
	protected AbstractXmlLoader(Client client){
		this.client = client;
	}
	
	/**
	 * 解析数据源
	 * 
	 * @param info
	 * @return
	 */
	protected IDataSource createDataSource(Element info) {
		String type = info.elementText("Type");
		if ("oracle".equalsIgnoreCase(type) || "postgres".equalsIgnoreCase(type) || "postgre".equalsIgnoreCase(type) || "postgreSQL".equalsIgnoreCase(type)) {
			String id = info.attributeValue("Id");
			String url = info.elementText("Url");
			String user = info.elementText("User");
			String password = info.elementText("Password");
			DbDataSource dbDataSource = new DbDataSource(id, url, user, password, null);
			//this.getInfoByStr(info, dbDataSource, "Url,Id,User,Password");
			if("oracle".equalsIgnoreCase(type)){
				dbDataSource.setDataSourceType(DATA_SOURCE_TYPE.oracle);
			}
			
			if("postgres".equalsIgnoreCase(type) || "postgre".equalsIgnoreCase(type) || "postgreSQL".equalsIgnoreCase(type)){
				dbDataSource.setDataSourceType(DATA_SOURCE_TYPE.postgreSQL);
			}
			
			if("mysql".equalsIgnoreCase(type)){
				dbDataSource.setDataSourceType(DATA_SOURCE_TYPE.mysql);
			}
			
			return dbDataSource;
		}
		if ("mongodb".equalsIgnoreCase(type)) {
			MongodbDataSource mongodbDataSource = new MongodbDataSource(null);
			this.getInfoByStr(info, mongodbDataSource, "Ip,Namespace,Id,User,Password");
			Integer port;
			try{
				port = Integer.valueOf(info.elementText("Port"));
			}catch(Exception e){
				port = null;
			}
			if(port == null){
				try{
					port = Integer.valueOf(info.elementText("Post"));
				}catch(Exception e){
					port = null;
				}
			}
			if(port == null){
				throw new RuntimeException("port必须为空且必须是整数");
			}
			mongodbDataSource.setPort(port);
			
			return mongodbDataSource;
		}
		throw new RuntimeException("现在不支持 " + type + " 的数据库");
	}

	/**
	 * 从XML中去信息
	 * 
	 * @param item
	 * @param t
	 * @param fieldsStr
	 *            字段,已逗号隔开
	 */
	protected <T> void getInfoByStr(Element item, T t, String fieldsStr) {
		String[] fieldArr = fieldsStr.split(",");
		for (String field : fieldArr) {
			String value = null;

			if ("Id".equalsIgnoreCase(field)) {
				value = item.attributeValue("Id");
				if(value == null){
					value = "_tmp";
				}
			} else {
				value = item.elementText(field);
			}
			if (value != null && !"".equalsIgnoreCase(value)) {
				value = value.trim();
			}else{
				//throw new RuntimeException("处理" + field + "出错," + field + "不能为空值");
			}
			field = field.substring(0, 1).toLowerCase() + field.substring(1);
			try {
				Bean.setSingleObjectValueByFieldName(t, field, value);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				throw new RuntimeException("处理" + field + "出错");
			}
		}
	}
	
	/**
	 * 自动注册数据服务（如果有，则不注册，只能注册只读服务）
	 * @param info
	 * @param id
	 * @return
	 * @throws Exception
	 */
	protected IDataService autoRegisterDBDataService(Element info,IDataSourceInService dataSourceInService,String id, String name) throws Exception {
		
		String tableName = info.elementText("Tablename");
		
		String spatialField = info.elementText("ShapeField");
		// 处理字段
		String originFields = info.elementText("Fields");
		//过滤条件
		String filter = info.elementText("SQLFilter");
		//自动创建只能是readonly的数据服务
		Boolean readonly = true;
		
		String[] fields = originFields.split(",");
	
		DataServiceBean dataService = new DataServiceBean(id,spatialField,dataSourceInService.getId(), tableName, readonly, fields,null);
		dataService.setFilter(filter);
		dataService.setName(name);
		IDataServiceManager dataServiceManager = this.client.getDataServiceManager();
		IDataService dataServiceShell = new DataServiceShell(client,dataService);

		if (dataServiceManager.get(id) != null){
			dataServiceManager.unRegister(id);
			dataServiceShell.start();
			try {
				this.client.getDataServiceManager().register(dataServiceShell);
			} catch (  ZKException  e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				throw new Exception(e);
			}

			return dataServiceShell;
			/*if (!dataServiceShell.equals(dataServiceManager.get(id))){
				throw new RuntimeException("id为"+ id +"的数据服务已经存在，且与正在注册的数据服务信息不一致");
			}
			return dataServiceManager.get(id);*/
		}else {
			dataServiceShell.start();
			try {
				this.client.getDataServiceManager().register(dataServiceShell);
			} catch (  ZKException  e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				throw new Exception(e);
			}

			return dataServiceShell;
		}

	}
	
	protected DataSetBean createDataSet(DataServiceBean dataService,Element info){
		
		
		String idInXML = info.attributeValue("Id");
		
		DataSetBean dataSet = new DataSetBean(idInXML,dataService.getId());
		
		String spatialFilter = info.elementText("SpatialFilter");
		if(spatialFilter != null){
			if (!"".equalsIgnoreCase(spatialFilter)) {
				dataSet.setSpatialFilter(spatialFilter);
			}
		}
		
		String filter = info.elementText("SQLFilter");
		if(filter != null){
			if (!"".equalsIgnoreCase(filter)) {
				dataSet.setFilter(filter);
			}
		}
		
		//以后加入sort
		
		/*String sortStr = info.elementText("Sort");
		if (sortStr != null) {
			if (!"".equalsIgnoreCase(sortStr)) {
				String[] sortArr = sortStr.split("=");
				if (sortArr.length != 2) {
					throw new RuntimeException("数据集 " + dataSet.getDataServiceId() + " 设置排序字段格式错误 ，格式应为 {field}=asc格式");
				}
				if ((!sortArr[1].equalsIgnoreCase("asc")) && (!sortArr[1].equalsIgnoreCase("desc"))) {
					throw new RuntimeException("数据集 " + dataSet.getDataServiceId() + " 设置排序字段格式错误 ，格式应为 {field}=asc格式");
				}
			
				dataSet.setSortFiled(refSortField);
				dataSet.setSort(sortArr[1]);

			}
		}*/
		
		return dataSet;
		
	}
	
	
	
	protected void checkAllDataSet(Element root,Map<String, IDataSourceInService> dataSourceMap) throws Exception {
		@SuppressWarnings("unchecked")
		List<Element> items = root.element("DataSets").elements();
		for (Element item : items) {
			String dataSourceId = item.elementText("DataSource");
			IDataSourceInService dataSourceInService = dataSourceMap.get(dataSourceId);
			if (dataSourceInService == null) {
				throw new Exception("没有找到名称为 " + dataSourceInService + " 数据源");
			}
			String idInXML = item.attributeValue("Id");
			String fields = item.elementText("Fields");
			String spatialFieldsName = item.elementText("ShapeField");
			String tableName = item.elementText("Tablename");
			//开始检查表是否存在，字段是否正确，空间字段是否正确；
			ITableOperator tableBuilder = null;
			try {
				tableBuilder = dataSourceInService.getTableBuilder(tableName);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				throw new Exception(String.format("dataset %s ,获取%s表信息失败,错误信息：%s",idInXML,tableName,e.getMessage()));
			}
			String[] fieldsArr = fields.split(",");
			for(String fieldName : fieldsArr){
				if(tableBuilder.getColumnMap().get(fieldName) == null){
					throw new Exception(String.format("dataset %s ,%s表没有找到字段 %s", idInXML,tableName,fieldName));
				}
			}
			IColumn column = tableBuilder.getColumnMap().get(spatialFieldsName);
			if(column == null){
				throw new Exception(String.format("dataset %s ,%s表没有找到字段 %s", idInXML,tableName,spatialFieldsName));
			}
			if(!column.isSpatial()){
				throw new Exception(String.format("dataset %s ,%s表,字段 %s,不是空间字段", idInXML,tableName,spatialFieldsName));
			}
		}
	}
	
	
	
	protected Map<String, DataSetBean> getDataSetMap(Element root, Map<String, IDataSourceInService> dataSourceMap) throws Exception {
		Map<String, DataSetBean> dataSetMap = new HashMap<String, DataSetBean>();
		@SuppressWarnings("unchecked")
		List<Element> items = root.element("DataSets").elements();
		
		this.checkAllDataSet(root, dataSourceMap);
			
		for (Element item : items) {
			
			String dataSourceId = item.elementText("DataSource");
			
			IDataSourceInService dataSourceInService = dataSourceMap.get(dataSourceId);
			
			if (dataSourceInService == null) {
				throw new Exception("没有找到名称为 " + dataSourceInService + " 数据源");
			}
			
			String idInXML = item.attributeValue("Id");
			String id = "autocreate_" + idInXML + "@" + dataSourceInService.mark();
		
			IDataService dataServiceShell = this.autoRegisterDBDataService(item, dataSourceInService,id, idInXML);

			//this.client.getDataServiceManager().start(id);
			
			DataServiceBean dataService = dataServiceShell.getBean();
			
			DataSetBean dataSet = this.createDataSet(dataService, item);
			
			dataSetMap.put(dataSet.getId(), dataSet);
			
		}
		return dataSetMap;
	}
	
	
	/*protected IDataService createDataService(Element item,IDataSourceInService dataSourceInService,String id) throws Exception{
		
		DATA_SOURCE_TYPE type = dataSourceInService.getDataSourceType();
		switch(type){
			case oracle:{
				return this.autoRegisterDBDataService(item, (DbDataSource)dataSourceInService.getBean(),id);
			}
			case postgreSQL:{
				return this.autoRegisterDBDataService(item, (DbDataSource)dataSourceInService.getBean(),id);
			}
			case mysql:{
				return this.autoRegisterDBDataService(item, (DbDataSource)dataSourceInService.getBean(),id);
			}
		}
		throw new Exception("目前不支持数据源:" + type.name());
	}*/
	
	
	
	
	protected Integer getInteger(Element info,String elementName){
		String valueStr = info.elementText(elementName);
		if(valueStr == null){
			valueStr = info.attributeValue(elementName);
		}
		
		if(valueStr == null){
			return null;
		}
		
		if("".equalsIgnoreCase(valueStr)){
			return null;
		}
		
		try{
			Integer value = Integer.valueOf(valueStr);
			return value;
		}catch(Exception e){
			throw new RuntimeException("xml中" + elementName + "必须是Integer类型");
		}
	}
	
	protected Double getDouble(Element info,String elementName){
		String valueStr = info.elementText(elementName);
		if(valueStr == null){
			valueStr = info.attributeValue(elementName);
		}
		
		if(valueStr == null){
			return null;
		}
		
		if("".equalsIgnoreCase(valueStr)){
			return null;
		}
		
		try{
			Double value = Double.valueOf(valueStr);
			return value;
		}catch(Exception e){
			throw new RuntimeException("xml中" + elementName + "必须是Double类型");
		}
	}
	
	
	protected Boolean getBoolean(Element info,String elementName){
		String valueStr = info.elementText(elementName);
		if(valueStr == null){
			valueStr = info.attributeValue(elementName);
		}
		
		if(valueStr == null){
			return null;
		}
		
		if("".equalsIgnoreCase(valueStr)){
			return null;
		}
		
		try{
			Boolean value = Boolean.valueOf(valueStr);
			return value;
		}catch(Exception e){
			throw new RuntimeException("xml中" + elementName + "必须是Boolean类型");
		}
	}
	
	private void validateXMLSchema(InputStream inXMl) throws SAXException, IOException{
		SchemaFactory factory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
        Schema schema;
		schema = factory.newSchema(new File(this.getValidateXMLPath()));
		Validator validator = schema.newValidator();
        validator.validate(new StreamSource(inXMl));
	}
	
	
	public void validateXML(InputStream inXMl) throws Exception{
		try {
			this.validateXMLSchema(inXMl);
			inXMl.markSupported();
		} catch (SAXException e1) {
			// TODO Auto-generated catch block
			throw new Exception("xml格式错误:" + e1.toString().replaceAll("org.xml.sax.SAXParseException;", ""));
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new Exception("没有找到XML校验文件");
		} finally{
			inXMl.close();
		}
	}
	

}
