package com.northpool.service.xmlloader.vectorservice;


import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.command.Constants.OPERATION;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.service.client.Client;
import com.northpool.service.config.Constants.LABEL_TYPE;
import com.northpool.service.config.data_source.DataScourceShell;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.CacheInfoBean;
import com.northpool.service.config.vector_service.VectorServiceBean;
import com.northpool.service.config.vector_service.dataset.DataSetBean;
import com.northpool.service.config.vector_service.layer.Label;
import com.northpool.service.config.vector_service.layer.LayerBean;
import com.northpool.service.config.vector_service.layer.LayerLevelBean;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.service.manager.abstractclass.ZKException;
import com.northpool.service.manager.data_sources.IDataSourcesManager;
import com.northpool.service.xmlloader.LoadXmlException;
import com.northpool.service.xmlloader.XmlLoader;
import com.northpool.spatial.grid.GridManager;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.InputStream;
import java.util.*;


public class VectorServiceLoader extends AbstractXmlLoader implements XmlLoader<VectorServiceBean>{
	 
	public VectorServiceLoader(Client client) {
		super(client);
		// TODO Auto-generated constructor stub
	}

	public final static String VERSION = "v1.0";
	public final static String SERVICE_TYPE = "vector_service";
	public final static String LAYER_SUFFIX = "_layer";
	public final static String LABEL_SUFFIX = "_label";
	public final static String STORAGE_PREFIX = "storage_";
	
	
	
	
	
	@Override
	protected String getValidateXMLPath() {
		// TODO Auto-generated method stub
		return this.getClass().getResource("").getPath() + "vector_server_register.xsd";
	} 
	
	

	
	
	
	
	
	public VectorServiceBean load(InputStream inXMl) throws LoadXmlException{
		try{
			SAXReader reader = new SAXReader();
			Document document = reader.read(inXMl);
			Element e = document.getRootElement();
			VectorServiceBean vectorService = null;
			if("vindex".equalsIgnoreCase(e.getName())){
				Element item = (Element) e.element("VectorTileServers").elements().get(0);
				vectorService = this.parseInfo(item);
			}else{
				 vectorService = this.parseInfo(e);
			}
			return vectorService;
		}catch(Exception e){
			e.printStackTrace();
			throw new LoadXmlException("加载XML出错" + e.getMessage());
		}
	}
	
	
	
	
	
	
	public List<VectorServiceBean> loadList(InputStream inXMl) throws LoadXmlException {
		try{
			SAXReader reader = new SAXReader();
			Document document = reader.read(inXMl);
			Element root = document.getRootElement();
			@SuppressWarnings("unchecked")
			List<Element> items = root.element("VectorTileServers").elements();
			List<VectorServiceBean> vectorServerRegisterBeanArr = new ArrayList<VectorServiceBean>();
			for (Element item : items) {
				VectorServiceBean vectorServerRegisterBean = this.parseInfo(item);
				vectorServerRegisterBeanArr.add(vectorServerRegisterBean);
			}
			return vectorServerRegisterBeanArr;
		}catch(Exception e){
			e.printStackTrace();
			throw new LoadXmlException(e.getMessage());
		}
	}
	
	@SuppressWarnings("unused")
	private CacheInfoBean createCacheInfo(Element item,Map<String, IDataSourceInService> dataSourceMap){
		String tileSaver = item.elementText("TileSaver");
		
		IDataSourceInService tileSaverDataSource = dataSourceMap.get(tileSaver);
		
		
		/*if (tileSaverDataSource != null) {
			vectorService.setTileSaver(tileSaverDataSource);
		} else {
			throw new RuntimeException("没有配置存储数据源");
		}*/
		return null;
	}
	// 解析瓦片存储数据源
	private VectorServiceBean parseInfo(Element item) throws Exception {
		VectorServiceBean vectorService = new VectorServiceBean();
		this.getInfoByStr(item, vectorService, "Id");
		try{
			String gridTreeName = "";
			if (item.elementText("Grid") != null){
				gridTreeName = item.elementText("Grid");
			}else{
				String gridBase = "degree";
				if (item.elementText("GridUnit") != null){
					gridBase = item.elementText("GridUnit");
				}
				gridTreeName = "tdt_" + gridBase + "_base512";
			}
			
			//checkGridTreeName
			
			if(GridManager.getQuadtreeGrid(gridTreeName) == null){
				throw new RuntimeException("没有找到网格 " + gridTreeName);
			}
			
			
			vectorService.setGridTreeName(gridTreeName);
			
			// 解析数据源
			Map<String, IDataSourceInService> dataSourceShellMap = this.getDataSourceMap(item);
			
			// 解析数据集
			Map<String, DataSetBean> dataSetMap = this.getDataSetMap(item, dataSourceShellMap);
			
			vectorService.setDataSetMap(dataSetMap);
			
			// 解析图层
			Map<String, LayerBean> layerMap = this.getLayerMap(item, dataSetMap);
			
			vectorService.setLayerMap(layerMap);
			
			// 解析存储
			StorageInfoBean storageInfoBean = this.getStorageInfoBean(item,dataSourceShellMap,vectorService);
			
			if(storageInfoBean != null){
				vectorService.setStorageInfo(storageInfoBean);
			}
	
			return vectorService;
		}catch(Exception e){
			e.printStackTrace();
			throw new LoadXmlException(vectorService.getId() + "解析" + e.getMessage());
		}

	}
	
	
	
	private StorageInfoBean getStorageInfoBean(Element item,Map<String, IDataSourceInService> dataSourceShellMap,VectorServiceBean vectorService){
		String tileSaver = item.elementText("TileSaver");
		if(tileSaver != null){
			IDataSourceInService dataSourceInService = dataSourceShellMap.get(tileSaver);
			if(dataSourceInService == null){
				throw new RuntimeException("在数据源中没有找到 存储名称为:" + tileSaver + " 的瓦片存储数据源");
			}
			if(dataSourceInService.getDataSourceType() != DATA_SOURCE_TYPE.mongodb){
				throw new RuntimeException("存储数据源 " + tileSaver + " 不支持:数据源类型 " + dataSourceInService.getDataSourceType());
			}
			StorageInfoBean storageInfoBean = new StorageInfoBean();
			storageInfoBean.setDataSourceId(dataSourceInService.getId());
			String serviceId = vectorService.getId();
			storageInfoBean.setStorageName(STORAGE_PREFIX + serviceId + LAYER_SUFFIX);
			storageInfoBean.setLabelStorageName(STORAGE_PREFIX + serviceId + LABEL_SUFFIX);
			storageInfoBean.setCompleted(false);
			return storageInfoBean;
		}
		return null;
		
	}
	
	
	
	/**
	 * 解析数据源MAP
	 * 
	 * @param root
	 * @return
	 */
	protected Map<String, IDataSourceInService> getDataSourceMap(Element root) throws Exception {
		Map<String, IDataSourceInService> dataSourceMap = new HashMap<String, IDataSourceInService>();
		@SuppressWarnings("unchecked")
		List<Element> items = root.element("DataSources").elements();
	//	int serverCount = items.size();
		for (Element item : items) {
			IDataSource dataSource = this.createDataSource(item);
			String idInXML = dataSource.getId();
			IDataSourceInService dataScourceShell = this.autoRegisterDataSource(dataSource);
			dataSourceMap.put(idInXML, dataScourceShell);
		}
		return dataSourceMap;
	}

	/**
	 * 自动注册数据源（如果存在就不再注册）
	 * @param dataSource
	 * @return
	 */
	protected IDataSourceInService autoRegisterDataSource(IDataSource dataSource) throws Exception {
		String mark = dataSource.mark();
		QueryFilter queryFilter = new QueryFilter();
		queryFilter.addFilter("mark", OPERATION.EQ, mark);
		IDataSourceInService dataScourceShell = this.client.getDataSourcesManager().findOne(queryFilter);
		if(dataScourceShell == null){
			String id = "autocreate_" + dataSource.getId();
			IDataSourcesManager dataSourcesManager = this.client.getDataSourcesManager();
			dataScourceShell = new DataScourceShell(this.client, id,id,dataSource);
			if (dataSourcesManager.get(id) != null){
				if (!dataScourceShell.equals(dataSourcesManager.get(id))){//数据源存在且与当前数据源不一致，则给id加时间戳
					id = id + new Date().getTime();
					dataScourceShell = new DataScourceShell(this.client, id,id,dataSource);
					this.client.getDataSourcesManager().register(dataScourceShell);
				}
				return dataScourceShell;
			}else {
				try {
					this.client.getDataSourcesManager().register(dataScourceShell);
				} catch (ZKException  e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
					throw new RuntimeException(e);
				}
				return dataScourceShell;
			}

		}else{
			return dataScourceShell;
		}
		
	}
	
	
	private Map<String, LayerBean> getLayerMap(Element root, Map<String, DataSetBean> dataSetMap) throws Exception {
		Map<String, LayerBean> layerMap = new HashMap<String, LayerBean>();
		@SuppressWarnings("unchecked")
		List<Element> items = root.element("Layers").elements();
		for (Element item : items) {

			LayerBean layer = this.createLayer(root, item, dataSetMap);
			if(layer != null){
				layerMap.put(layer.getId(), layer);
			}

		}
		return layerMap;

	}
	
	private LayerBean createLayer(Element root, Element info, Map<String, DataSetBean> dataSetMap) throws Exception {
		//处理基本参数
		String layerId = info.attributeValue("Id");
		
		try{
			LayerBean layer = new LayerBean();
			this.getInfoByStr(info, layer, "Id,BeginLevel,EndLevel");
		
			
			String cutOutScreen = info.attributeValue("cutOutScreen");
			if(cutOutScreen == null){
				cutOutScreen = info.attributeValue("CutOutScreen");
			}
			if(cutOutScreen == null){
				cutOutScreen = info.elementText("CutOutScreen");
			}
			
			if("false".equalsIgnoreCase(cutOutScreen)){
				layer.setCutOutScreen(false);
			}
			
			Map<Integer,LayerLevelBean> allLayerLevel = new HashMap<Integer,LayerLevelBean>();
			for (Integer i = layer.getBeginLevel(); i <= layer.getEndLevel(); i++) {
				LayerLevelBean layerLevel = new LayerLevelBean();
				layerLevel.setLevel(i);		
				allLayerLevel.put(i, layerLevel);
			}
	
			//补充LayerLevel使用的dataset,如果有其他公用字段，也需要以同补充
			allLayerLevel = this.addDataSetToLayerLevel(info, allLayerLevel, dataSetMap);
			
			//根据level标签补充更多layerlevel信息
			
			allLayerLevel = this.addInfoToLayerLevel(info,allLayerLevel);
			// 加入标注
			layer.setLevelMap(allLayerLevel);
			Element lebelElement = info.element("Label");
			if (lebelElement != null) {
				layer.setHaveLabel(true);
				Label label = new Label();
				String type = lebelElement.attributeValue("Type");
				if(type.equalsIgnoreCase(LABEL_TYPE.line.name())){
					label.setType(LABEL_TYPE.line);
				}
				if(type.equalsIgnoreCase(LABEL_TYPE.point.name())){
					label.setType(LABEL_TYPE.point);
				//	layer.setLabelOnly(true);
				}
				if(type.equalsIgnoreCase(LABEL_TYPE.area.name())){
					label.setType(LABEL_TYPE.area);
				}
				
				String labelFilter = lebelElement.elementText("SQLFilter");
				if(labelFilter != null && !"".equalsIgnoreCase(labelFilter)){
					label.setFilter(labelFilter);
				}
				Boolean labelOnly = this.getBoolean(lebelElement, "labelOnly");
				if(labelOnly == null){
					labelOnly = this.getBoolean(lebelElement, "LabelOnly");
				}
				if(labelOnly != null && true == labelOnly){
					layer.setLabelOnly(true);
				}
				
				layer.setLabel(label);
			}
			return layer;
		}catch(Exception e){
			e.printStackTrace();
			throw new Exception(String.format("图层%s:%s",layerId,e.getMessage()));
			
		}

	}
	
	
	private String getDataSetId(Element item){
		String dataSetName;
		if(item.elements().isEmpty()){
			dataSetName = item.getStringValue();
		}else{
			dataSetName = item.elementText("DataSetId");
		}
	//	if()
		return dataSetName;
	}
	
	
	@SuppressWarnings("unchecked")
	private Map<Integer,LayerLevelBean> addInfoToLayerLevel(Element info,Map<Integer,LayerLevelBean> allLayerLevel){
		List<Element> items = new ArrayList<Element>();
		if(info.element("Levels") != null){
			items = info.element("Levels").elements();
		}
		
		for (Element item : items) {
			
			String value = item.attributeValue("Id");
			
			String sqlFilter = item.elementText("SQLFilter");
			
			Double simplify = this.getDouble(item,"simplify");
			if(simplify == null){
				simplify = this.getDouble(item,"Simplify");
			}

			Integer lineCutBase = this.getInteger(item, "LineCutBase");
			Integer minCutPixel = this.getInteger(item, "LineMinCutPixel");
			Integer minCutPoint = this.getInteger(item, "LineMinCutPoint");

			Integer level = 0;
			try {
				level = Integer.valueOf(value);
			} catch (Exception e) {
				throw new RuntimeException("图层level必须是整数型");
			}
			LayerLevelBean layerLevel = allLayerLevel.get(level);
			if(layerLevel == null){
				continue;
			}
			if(sqlFilter != null && !"".equals(sqlFilter)){
				
				layerLevel.addSQLFilter(sqlFilter);
				
			}
			if (simplify != null) {
				layerLevel.setSimplifyForLayerLevel(Double.valueOf(simplify));
			}

			if(lineCutBase != null){
				layerLevel.setLineCutBase(lineCutBase);
			}
			if(minCutPixel != null){
				layerLevel.setMinCutPixel(minCutPixel);
			}
			if(minCutPoint != null){
				layerLevel.setMinCutPoint(minCutPoint);
			}
		}
		return allLayerLevel;
		
	}
	
	
	private Map<Integer,LayerLevelBean> addDataSetToLayerLevel(Element info,Map<Integer,LayerLevelBean> allLayerLevel,Map<String, DataSetBean> dataSetMap) throws Exception{
		if(info.element("DataSet").elements().size() == 0){
			String dataSetId = info.element("DataSet").getTextTrim();
			if(dataSetMap.get(dataSetId) == null){
				throw new Exception(String.format("没有找到数据集%s", dataSetId));
			}
			
			allLayerLevel.entrySet().forEach( entry ->{
				entry.getValue().setDataSetId(dataSetId);
			});
		}else{
			@SuppressWarnings("unchecked")
			List<Element> items = info.element("DataSet").elements();
			@SuppressWarnings("unused")
			List<String> fieldsList = null;
			for (Element item : items) {
				// 获得数据源
				String dataSetId = this.getDataSetId(item);
				
				DataSetBean dataSet = dataSetMap.get(dataSetId);
				if (dataSet == null) {
					throw new Exception(String.format("没有找到数据集%s", dataSetId));
				}				
				Integer begin = this.getInteger(item, "begin");
				if(begin == null){
					begin = this.getInteger(item, "Begin");
				}
				Integer end = this.getInteger(item,"end");
				if(end == null){
					end = this.getInteger(item,"End");
				}
				String sqlFilter = item.attributeValue("SQLFilter");
				if(sqlFilter == null){
					sqlFilter = item.elementText("SQLFilter");
				}
				
				Double simplify = this.getDouble(item,"simplify");
				if(simplify == null){
					simplify = this.getDouble(item,"Simplify");
				}

				for (Integer level = begin; level <= end; level ++) {
					LayerLevelBean layerLevel = allLayerLevel.get(level);
					layerLevel.setDataSetId(dataSetId);
					layerLevel.addSQLFilter(sqlFilter);
					layerLevel.setSimplifyForLayerLevel(simplify);
				}

			}
		}
		
		return allLayerLevel;
	}
	
	
	
	
	
	
	
	
	
	
}
