package com.northpool.service.config.data_service;

import com.alibaba.fastjson.JSON;
import com.northpool.resources.datatable.FieldEncoder;
import com.northpool.service.config.CanStartStop.STATE_TYPE;
import com.northpool.service.config.Constants.SERVICE_TYPE;
import com.northpool.service.config.data_service.tileInfo.AreaTileInfoBean;
import com.northpool.service.config.data_service.tileInfo.FeatureTileInfoBean;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.util.*;

public class DataServiceBean {
	

	/**
	 * 数据服务的ID
	 */
	
	protected String id;
	
	/**
	 * 名称
	 */
	protected String name;


	protected String filter;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}


	/**
	 * 指定的空间字段
	 */
	
	protected String spatialOriginFieldName;

	protected String geoType;
	/**
	 * 数据源ID
	 */
	
	protected String dataSourceId;
	/**
	 * 对应表名
	 */
	
	protected String tableName;
	
	
	protected Boolean readonly = false; 
	
	
	protected SERVICE_TYPE serviceType = SERVICE_TYPE.data_service;
	
	protected STATE_TYPE state = STATE_TYPE.standby;

	protected List<FieldsConfig> fields = new ArrayList<FieldsConfig>();

	/**
	 * 
	 */
	
	/**
	 * key:fieldOrigin,value:fieldAlias
	 */
	protected LinkedHashMap<String,String> aliasMap = new LinkedHashMap<>();

	protected DataServiceAdvancedOptions advancedOptions = new DataServiceAdvancedOptions();

	protected StorageInfoBean storageInfo;

	protected AreaTileInfoBean areaTileInfo;

	protected FeatureTileInfoBean featureTileInfo;


	protected String version;
	
	/*DataService(String id,String spatialField,String dataSourceId,String tableName,Boolean readonly,Field[] fields){
		this.id = id;
		this.spatialField = spatialField;
		this.dataSourceId = dataSourceId;
		this.tableName = tableName;
		this.readonly = readonly;
		this.fields = fields;
	}*/





	public Map<String, String> getAliasMap() {
		return aliasMap;
	}






	/**
	 * key:fieldOrigin,value:fieldAlias
	 * @param aliasMap
	 */
	public void setAliasMap(LinkedHashMap<String, String> aliasMap) {
		this.aliasMap = aliasMap;
	}




	public DataServiceBean(){
		
	}


	/**
	 * 
	 * @param id 主键
	 * @param spatialOriginFieldName 空间字段名称
	 * @param dataSourceId 数据源名称
	 * @param tableName 表名称
	 * @param readonly 是否只读
	 * @param fields 所选字段
	 * @param aliasMap 字段映射表key:fieldOrigin,value:fieldAlias
	 */
	public DataServiceBean(String id,String spatialOriginFieldName,String dataSourceId,String tableName,Boolean readonly,String[] fields, LinkedHashMap<String,String> aliasMap){
		this.id = id;
		this.spatialOriginFieldName = spatialOriginFieldName;
		this.dataSourceId = dataSourceId;
		this.tableName = tableName;
		this.readonly = readonly;
		if(aliasMap == null){
			aliasMap = new LinkedHashMap<String,String>();
		}
		for(String field : fields){
			String aliaseName = aliasMap.get(field);
			if(aliaseName == null){
				aliaseName = FieldEncoder.DEFAULT_ENCODER.encode(field);
			}
			aliasMap.put(field, aliaseName);
		}
		this.aliasMap = aliasMap;
	}

	
	
	




	public String getId() {
		return id;
	}







	public void setId(String id) {
		this.id = id;
	}





	public String getSpatialOriginFieldName() {
		return spatialOriginFieldName;
	}

	public String getSpatialFieldName() {
		return this.aliasMap.get(spatialOriginFieldName);
	}







	public void setSpatialOriginFieldName(String spatialOriginFieldName) {
		this.spatialOriginFieldName = spatialOriginFieldName;
	}







	public String getDataSourceId() {
		return dataSourceId;
	}







	public void setDataSourceId(String dataSourceId) {
		this.dataSourceId = dataSourceId;
	}







	public String getTableName() {
		return tableName;
	}







	public void setTableName(String tableName) {
		this.tableName = tableName;
	}







	public Boolean getReadonly() {
		return readonly;
	}







	public void setReadonly(Boolean readonly) {
		this.readonly = readonly;
	}







	public SERVICE_TYPE getServiceType() {
		return serviceType;
	}







	public void setServiceType(SERVICE_TYPE serviceType) {
		this.serviceType = serviceType;
	}







	public STATE_TYPE getState() {
		return state;
	}



	public void setState(STATE_TYPE state) {
		this.state = state;
	}


	public String getFilter() {
		return filter;
	}

	public void setFilter(String filter) {
		this.filter = filter;
	}

	public String toJson() {
		// TODO Auto-generated method stub
		return JSON.toJSONString(this);
	}

	public List<FieldsConfig> getFields() {
		return fields;
	}

	public void setFields(List<FieldsConfig> fields) {
		this.fields = fields;
	}

	public StorageInfoBean getStorageInfo() {
		return storageInfo;
	}

	public void setStorageInfo(StorageInfoBean storageInfo) {
		this.storageInfo = storageInfo;
	}


	public AreaTileInfoBean getAreaTileInfo() {
		return areaTileInfo;
	}

	public void setAreaTileInfo(AreaTileInfoBean areaTileInfo) {
		this.areaTileInfo = areaTileInfo;
	}

	public FeatureTileInfoBean getFeatureTileInfo() {
		return featureTileInfo;
	}

	public void setFeatureTileInfo(FeatureTileInfoBean featureTileInfo) {
		this.featureTileInfo = featureTileInfo;
	}

	public DataServiceAdvancedOptions getAdvancedOptions() {
		return advancedOptions;
	}

	public void setAdvancedOptions(DataServiceAdvancedOptions advancedOptions) {
		this.advancedOptions = advancedOptions;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public String getGeoType() {
		return geoType;
	}

	public void setGeoType(String geoType) {
		this.geoType = geoType;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;

		if (o == null || getClass() != o.getClass()) return false;

		DataServiceBean that = (DataServiceBean) o;

		String fields = StringUtils.join(this.aliasMap.keySet(),",");
		String thatFields = StringUtils.join(that.getAliasMap().keySet(),",");

		return new EqualsBuilder()
				.append(name, that.name)
				.append(spatialOriginFieldName, that.spatialOriginFieldName)
				.append(dataSourceId, that.dataSourceId)
				.append(tableName, that.tableName)
				.append(serviceType, that.serviceType)
				.append(fields, thatFields)
				.isEquals();
	}

	@Override
	public int hashCode() {
		return new HashCodeBuilder(17, 37)
				.append(name)
				.append(spatialOriginFieldName)
				.append(dataSourceId)
				.append(tableName)
				.append(serviceType)
				.append(aliasMap)
				.toHashCode();
	}
}
