package com.northpool.service.config.font;

import com.alibaba.fastjson.JSON;
import com.northpool.bean.JsonableBuilder;
import com.northpool.service.manager.abstractclass.DocumentableBuilder;
import org.bson.Document;

public class FontBuilder implements JsonableBuilder<IFontService>, DocumentableBuilder<IFontService> {

    private static FontBuilder _FONT_BUILDER = new FontBuilder();

    public static FontBuilder getInstance() {
        return _FONT_BUILDER;
    }

    public IFontService fromJson(String json) {
        FontBean fontBean = JSON.parseObject(json, FontBean.class);
        return new FontShell(fontBean);
    }

    @Override
    public IFontService fromDocument(Document str) {
        str.remove("_id");
        return this.fromJson(str.toJson());
    }
}
