package com.northpool.service.config.font;

import com.northpool.service.config.Constants;
import org.bson.Document;

public class FontShell implements IFontService {

    FontBean font;

    public FontShell(FontBean font){
        this.font = font;
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    @Override
    public String getId() {
        return font.getId();
    }

    @Override
    public String toJson() {
        return font.toJson();
    }

    @Override
    public byte[] getContent() {
        return font.getContent();
    }

    @Override
    public String getVersion() {
        return font.getVersion();
    }

    @Override
    public String getFilename() {
        return this.font.getFilename();
    }

    @Override
    public String getFamily() {
        return font.getFamily();
    }

    @Override
    public Constants.FONT_WEIGHT getWeight() {
        return font.getWeight();
    }

    @Override
    public Constants.FONT_STYLE getStyle() {
        return font.getStyle();
    }

    @Override
    public Constants.FONT_FILE_TYPE getFileType() {
        return font.getFileType();
    }

    @Override
    public Boolean isDefaultFont() {
        return font.isDefaultFont();
    }

    @Override
    public Boolean isForeendUnCommon() {
        return font.isForeendUnCommon();
    }

    @Override
    public Boolean isBackendUnCommon() {
        return font.isBackendUnCommon();
    }

    @Override
    public Document toDocument() {
        return Document.parse(this.toJson());
    }
}
