package com.northpool.service.config.style;

import com.alibaba.fastjson.JSON;
import org.bson.Document;

import java.util.Arrays;

public class StyleShell implements IStyleService {

    StyleBean style;



    public StyleShell(StyleBean style){
        this.style = style;
    }

    @Override
    public String getId() {
        return style.getUuid();
    }

    @Override
    public String toJson() {
        return style.toJson();
    }

    public StyleBean getStyle() {
        return style;
    }

    public void setStyle(StyleBean style) {
        this.style = style;
    }

    @Override
    public String getName() {
        return style.getName();
    }

    @Override
    public String getOwnServer() {
        return style.getOwnServer();
    }

    @Override
    public String getStyleJson() {
        return style.getStyleJson();
    }

    @Override
    public String getVersion() {
        return style.getVersion();
    }

    @Override
    public void setVersion(String version) {
        style.setVersion(version);
    }

    @Override
    public String getUuid() {
        return style.getUuid();
    }

    @Override
    public StyleBean getBean() {
        return this.style;
    }

    @Override
    public StyleJson getStyleJsonBean() {
        return JSON.parseObject(this.style.getStyleJson(), StyleJson.class);
    }

    @Override
    public void setStyleJson(String styleJson) {
        this.style.setStyleJson(styleJson);
    }

    @Override
    public Double getXmin() {
        return style.getXmin();
    }

    @Override
    public Double getYmin() {
        return style.getYmin();
    }

    @Override
    public Double getXmax() {
        return style.getXmax();
    }

    @Override
    public Double getYmax() {
        return style.getYmax();
    }


    @Override
    public String toString() {
        return this.toJson();
    }

    @Override
    public Document toDocument() {
        Document doc = Document.parse(this.toJson());
        doc.remove("textureLabel");
        doc.remove("textureLayer");
        if (this.style.getTextureLabel() != null){
            doc.put("texture_label", Arrays.asList(this.style.getTextureLabel()));
        }

        if (this.style.getTextureLayer() != null){
            doc.put("texture_layer", Arrays.asList(this.style.getTextureLayer()));
        }
        doc.put("styleLayerJs", this.style.getStyleLayerJs());
        doc.put("styleLabelJs", this.style.getStyleLabelJs());
        doc.put("styleAvoidjs", this.style.getStyleAvoidjs());
        doc.put("queryLayer", this.style.getQueryLayer());
        doc.put("queryLabel", this.style.getQueryLabel());
        return doc;
    }
}
