package com.northpool.service.config.texture;

import com.alibaba.fastjson.JSON;
import com.northpool.bean.JsonableBuilder;
import com.northpool.service.manager.abstractclass.DocumentableBuilder;
import org.bson.Document;

public class TextureBuilder implements JsonableBuilder<ITextureService>, DocumentableBuilder<ITextureService> {

    private static TextureBuilder _TEXTURE_BUILDER = new TextureBuilder();

    public static TextureBuilder getInstance() {
        return _TEXTURE_BUILDER;
    }

    public ITextureService fromJson(String json) {
        TextureBean textureBean = JSON.parseObject(json, TextureBean.class);
        return new TextureShell(textureBean);
    }

    @Override
    public ITextureService fromDocument(Document str) {
        str.remove("_id");
        return this.fromJson(str.toJson());
    }
}
