package com.northpool.service.dao;

import com.northpool.bean.Idable;
import com.northpool.bean.Jsonable;
import com.northpool.service.config.IDocumentAble;
import org.bson.conversions.Bson;

import java.util.List;

public interface IMongoDao<T extends Jsonable & Idable<String> & IDocumentAble>{

    public T findone(String id);

    public T findone(Bson filter);


    public void deleteone(String id);

    public void updateOne(String id, T bean);

    public void insertOne(T bean);

    public List<T> find(Bson filter);

    public Long count(Bson filter);

    public Boolean exists(String id);


}
