package com.northpool.service.manager.cell;

import com.northpool.service.manager.IClientManager;
import io.netty.channel.ChannelHandlerContext;

public interface ITileDataCellManager extends IClientManager {

    /*
     * @Author lz
     * @Description //动态获取瓦片数据接口
     * @Date 10:13 2020/7/21
     * @Param [serverName, gridstr, x, y, level, filter, limit, _cut]
     * @return byte[]
     **/
    void getData(String serverName, String layerName, String type, String gridstr, Integer x, Integer y, Integer level, String filter, Boolean _cut, Integer start, Integer limit, ChannelHandlerContext ctx, byte[] markByte) throws Exception;


    void getDataSetData(String serverName, String dataLayerName, String filterStr, String spatialFilter, String fields, String ids, Integer start, Integer limit, Integer level, Boolean withGeometry, Boolean withExtent,  Boolean withCenter, ChannelHandlerContext ctx, byte[] markByte)
            throws Exception;

    void getDataSetDataCount(String serverName, String dataLayerName, String filterStr, String spatialFilter, String ids, Integer level, ChannelHandlerContext ctx, byte[] markByte) throws Exception;

    byte[] getDataSetInfo(String serverName, String dataLayerName, Integer level) throws Exception;

    void getArea(String serverName, String dataLayerName, String filterStr, String spatialFilter, String fields, ChannelHandlerContext ctx, byte[] markByte);

    byte[] getArea(String serverName, String dataLayerName, String filterStr, String spatialFilter, String fields) throws Exception;
}
